/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import org.openl.binding.impl.NodeDescriptionHolder;
import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellRefType;
import org.openl.rules.calc.element.SpreadsheetStructureBuilderHolder;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetCellField
extends ASpreadsheetField
implements NodeDescriptionHolder {
    protected final SpreadsheetCell cell;
    private final SpreadsheetStructureBuilderHolder structureBuilderContainer;
    private final SpreadsheetCellRefType refType;
    private IOpenClass type;

    public SpreadsheetCellField(SpreadsheetStructureBuilderHolder structureBuilderContainer, IOpenClass declaringClass, String name, SpreadsheetCell cell, SpreadsheetCellRefType refType) {
        super(declaringClass, name, cell.getType());
        this.cell = cell;
        this.structureBuilderContainer = structureBuilderContainer;
        this.refType = refType;
    }

    public boolean isLastRowRef() {
        return SpreadsheetCellRefType.SINGLE_ROW.equals((Object)this.refType);
    }

    public boolean isLastColumnRef() {
        return SpreadsheetCellRefType.SINGLE_COLUMN.equals((Object)this.refType);
    }

    public Object get(Object target, IRuntimeEnv env) {
        SpreadsheetResultCalculator spreadsheetResultCalculator = (SpreadsheetResultCalculator)target;
        if (spreadsheetResultCalculator == null) {
            return this.getType().nullObject();
        }
        return spreadsheetResultCalculator.getValue(this.cell.getRowIndex(), this.cell.getColumnIndex());
    }

    public SpreadsheetCell getCell() {
        return this.cell;
    }

    public IOpenClass getType() {
        if (this.type == null) {
            IOpenClass t = this.cell.getType();
            if (t == null) {
                if (this.structureBuilderContainer.getSpreadsheetStructureBuilder() == null) {
                    throw new IllegalStateException("Spreadsheet cell type is not resolved at compile time");
                }
                t = this.structureBuilderContainer.getSpreadsheetStructureBuilder().makeType(this.cell);
            }
            this.type = t;
        }
        return this.type;
    }

    public boolean isWritable() {
        return false;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        throw new UnsupportedOperationException("Can not write to spreadsheet cell result");
    }

    @Override
    public String getDescription() {
        return this.getType().getDisplayName(0) + " " + this.getName();
    }

    public static class ConstSpreadsheetCellField
    extends SpreadsheetCellField {
        public ConstSpreadsheetCellField(SpreadsheetStructureBuilderHolder structureBuilderContainer, IOpenClass declaringClass, String name, SpreadsheetCell cell) {
            super(structureBuilderContainer, declaringClass, name, cell, SpreadsheetCellRefType.ROW_AND_COLUMN);
        }

        @Override
        public Object get(Object target, IRuntimeEnv env) {
            return this.cell.getValue();
        }
    }
}

