/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.sax;

import org.openl.excel.parser.sax.MinimalStyleTable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class StyleHandler
extends DefaultHandler {
    private final MinimalStyleTable styleTable = new MinimalStyleTable();
    private boolean startCellXfs = false;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String indent;
        if ("cellXfs".equals(localName)) {
            this.startCellXfs = true;
        } else if (this.startCellXfs && "xf".equals(localName)) {
            this.styleTable.addStyle(Integer.parseInt(attributes.getValue("numFmtId")));
        } else if ("numFmt".equals(localName)) {
            int numFmtId = Integer.parseInt(attributes.getValue("numFmtId"));
            String formatCode = attributes.getValue("formatCode");
            this.styleTable.addFormatString(numFmtId, formatCode);
        } else if (this.startCellXfs && "alignment".equals(localName) && (indent = attributes.getValue("indent")) != null) {
            this.styleTable.addIndent(Short.parseShort(indent));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("cellXfs".equals(localName)) {
            this.startCellXfs = false;
        }
    }

    public MinimalStyleTable getStyleTable() {
        return this.styleTable;
    }
}

