/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.event.style;

import java.util.Map;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

class PoiCellStyle
implements CellStyle {
    private final short index;
    private final ExtendedFormatRecord format;
    private final Map<Integer, FormatRecord> formats;

    PoiCellStyle(short index, ExtendedFormatRecord format, Map<Integer, FormatRecord> formats) {
        this.index = index;
        this.format = format;
        this.formats = formats;
    }

    public short getIndex() {
        return this.index;
    }

    public void setDataFormat(short fmt) {
    }

    public short getDataFormat() {
        return this.format.getFormatIndex();
    }

    public String getDataFormatString() {
        short formatIndex = this.getDataFormat();
        if (formatIndex < 0) {
            return null;
        }
        String format = formatIndex >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats() || this.formats.get(formatIndex) != null ? this.formats.get(formatIndex).getFormatString() : HSSFDataFormat.getBuiltinFormat((short)formatIndex);
        return format;
    }

    public void setFont(Font font) {
    }

    public int getFontIndex() {
        return this.format.getFontIndex();
    }

    @Deprecated
    public int getFontIndexAsInt() {
        return this.format.getFontIndex();
    }

    public void setHidden(boolean hidden) {
    }

    public boolean getHidden() {
        return this.format.isHidden();
    }

    public void setLocked(boolean locked) {
    }

    public boolean getLocked() {
        return this.format.isLocked();
    }

    public void setQuotePrefixed(boolean quotePrefix) {
    }

    public boolean getQuotePrefixed() {
        return this.format.get123Prefix();
    }

    public void setAlignment(HorizontalAlignment align) {
    }

    public HorizontalAlignment getAlignment() {
        return HorizontalAlignment.forInt((int)this.format.getAlignment());
    }

    public void setWrapText(boolean wrapped) {
    }

    public boolean getWrapText() {
        return this.format.getWrapText();
    }

    public void setVerticalAlignment(VerticalAlignment align) {
    }

    public VerticalAlignment getVerticalAlignment() {
        return VerticalAlignment.forInt((int)this.format.getVerticalAlignment());
    }

    public void setRotation(short rotation) {
    }

    public short getRotation() {
        short rotation = this.format.getRotation();
        if (rotation == 255) {
            return rotation;
        }
        if (rotation > 90) {
            rotation = (short)(90 - rotation);
        }
        return rotation;
    }

    public void setIndention(short indent) {
    }

    public short getIndention() {
        return this.format.getIndent();
    }

    public void setBorderLeft(BorderStyle border) {
    }

    public BorderStyle getBorderLeft() {
        return BorderStyle.valueOf((short)this.format.getBorderLeft());
    }

    public void setBorderRight(BorderStyle border) {
    }

    public BorderStyle getBorderRight() {
        return BorderStyle.valueOf((short)this.format.getBorderRight());
    }

    public void setBorderTop(BorderStyle border) {
    }

    public BorderStyle getBorderTop() {
        return BorderStyle.valueOf((short)this.format.getBorderTop());
    }

    public void setBorderBottom(BorderStyle border) {
    }

    public BorderStyle getBorderBottom() {
        return BorderStyle.valueOf((short)this.format.getBorderBottom());
    }

    public void setLeftBorderColor(short color) {
    }

    public short getLeftBorderColor() {
        return this.format.getLeftBorderPaletteIdx();
    }

    public void setRightBorderColor(short color) {
    }

    public short getRightBorderColor() {
        return this.format.getRightBorderPaletteIdx();
    }

    public void setTopBorderColor(short color) {
    }

    public short getTopBorderColor() {
        return this.format.getTopBorderPaletteIdx();
    }

    public void setBottomBorderColor(short color) {
    }

    public short getBottomBorderColor() {
        return this.format.getBottomBorderPaletteIdx();
    }

    public void setFillPattern(FillPatternType fp) {
    }

    public FillPatternType getFillPattern() {
        return FillPatternType.forInt((int)this.format.getAdtlFillPattern());
    }

    public void setFillBackgroundColor(short bg) {
    }

    public void setFillBackgroundColor(Color color) {
    }

    public short getFillBackgroundColor() {
        short autoIndex = HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
        short result = this.format.getFillBackground();
        if (result == autoIndex + 1) {
            return autoIndex;
        }
        return result;
    }

    public Color getFillBackgroundColorColor() {
        throw new UnsupportedOperationException();
    }

    public void setFillForegroundColor(short bg) {
    }

    public void setFillForegroundColor(Color color) {
    }

    public short getFillForegroundColor() {
        return this.format.getFillForeground();
    }

    public Color getFillForegroundColorColor() {
        throw new UnsupportedOperationException();
    }

    public void cloneStyleFrom(CellStyle source) {
    }

    public void setShrinkToFit(boolean shrinkToFit) {
    }

    public boolean getShrinkToFit() {
        return this.format.getShrinkToFit();
    }
}

