/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.module;

import org.openl.binding.IBindingContext;
import org.openl.binding.impl.cast.EnumToStringCast;
import org.openl.binding.impl.cast.INestedCastOpenCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.cast.StringToEnumCast;
import org.openl.rules.context.DefaultRulesRuntimeContext;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public final class ContextPropertyBinderUtils {
    private ContextPropertyBinderUtils() {
    }

    public static String validateContextProperty(String contextProperty, IOpenClass expectedType, IBindingContext bindingContext) {
        String errorMessage = null;
        Class<?> contextPropertyClass = DefaultRulesRuntimeContext.CONTEXT_PROPERTIES.get(contextProperty);
        if (contextPropertyClass == null) {
            errorMessage = String.format("Property '%s' is not found in the context. Available properties: [%s].", contextProperty, String.join((CharSequence)", ", DefaultRulesRuntimeContext.CONTEXT_PROPERTIES.keySet()));
        } else {
            JavaOpenClass contextPropertyType = JavaOpenClass.getOpenClass(contextPropertyClass);
            IOpenCast openCast = null;
            try {
                openCast = bindingContext.getCast(expectedType, (IOpenClass)contextPropertyType);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (ContextPropertyBinderUtils.isNonValidCastForContextProperty(openCast)) {
                errorMessage = String.format("Type mismatch for context property '%s'. Cannot convert from '%s' to '%s'.", contextProperty, expectedType.getName(), contextPropertyType.getName());
            }
        }
        return errorMessage;
    }

    public static boolean isNonValidCastForContextProperty(IOpenCast openCast) {
        return openCast == null || !openCast.isImplicit() && !(ContextPropertyBinderUtils.extractIfNestedOpenCast(openCast) instanceof EnumToStringCast) && !(ContextPropertyBinderUtils.extractIfNestedOpenCast(openCast) instanceof StringToEnumCast);
    }

    private static IOpenCast extractIfNestedOpenCast(IOpenCast openCast) {
        INestedCastOpenCast nestedCastOpenCast;
        if (openCast instanceof INestedCastOpenCast && (nestedCastOpenCast = (INestedCastOpenCast)openCast).hasNestedOpenCast()) {
            return nestedCastOpenCast.getNestedOpenCast();
        }
        return openCast;
    }
}

