/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ATargetBoundNode;
import org.openl.binding.impl.ConstructorNodeCreator;
import org.openl.binding.impl.FieldBoundNodeUsageCreator;
import org.openl.binding.impl.MethodBoundNodeUsageCreator;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.NodeUsageCreator;
import org.openl.binding.impl.TypeNodeUsageCreator;
import org.openl.util.CollectionUtils;

public final class NodeUsageFactory {
    private static final List<NodeUsageCreator> CREATORS = Arrays.asList(MethodBoundNodeUsageCreator.getInstance(), FieldBoundNodeUsageCreator.getInstance(), TypeNodeUsageCreator.getInstance(), ConstructorNodeCreator.getInstance());

    private NodeUsageFactory() {
    }

    public static List<NodeUsage> createNodeUsageList(IBoundNode boundNode, String sourceString, int startIndex) {
        ArrayList<NodeUsage> nodeUsages = new ArrayList<NodeUsage>();
        NodeUsageFactory.findNodeUsages(nodeUsages, boundNode, sourceString.substring(startIndex), startIndex);
        nodeUsages.sort(Comparator.comparingInt(NodeUsage::getStart));
        return Collections.unmodifiableList(nodeUsages);
    }

    private static void findNodeUsages(List<NodeUsage> nodeUsages, IBoundNode boundNode, String sourceString, int startIndex) {
        IBoundNode iBoundNode;
        if (boundNode == null) {
            return;
        }
        for (NodeUsageCreator nodeUsageCreator : CREATORS) {
            if (!nodeUsageCreator.accept(boundNode)) continue;
            nodeUsageCreator.create(boundNode, sourceString, startIndex).ifPresent(nodeUsages::add);
        }
        Object[] children = boundNode.getChildren();
        if (CollectionUtils.isNotEmpty((Object[])children)) {
            for (Object child : children) {
                NodeUsageFactory.findNodeUsages(nodeUsages, (IBoundNode)child, sourceString, startIndex);
            }
        }
        if (boundNode instanceof ATargetBoundNode && (iBoundNode = boundNode.getTargetNode()) != null) {
            NodeUsageFactory.findNodeUsages(nodeUsages, iBoundNode, sourceString, startIndex);
        }
    }
}

