/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.util.BitSet;
import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Arbiter;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.results.ZZ_Result;

public class JMMSample_02_WordTearing {

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"true, true"}, expect=Expect.ACCEPTABLE, desc="Seeing both updates intact."), @Outcome(id={"false, true"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="Destroyed one update."), @Outcome(id={"true, false"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="Destroyed one update.")})
    @State
    public static class BitSets {
        BitSet bs = new BitSet();

        @Actor
        public void writer1() {
            this.bs.set(0);
        }

        @Actor
        public void writer2() {
            this.bs.set(1);
        }

        @Arbiter
        public void arbiter(ZZ_Result r) {
            r.r1 = this.bs.get(0);
            r.r2 = this.bs.get(1);
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"true, true"}, expect=Expect.ACCEPTABLE, desc="Seeing both updates intact."), @Outcome(expect=Expect.FORBIDDEN, desc="Other cases are forbidden.")})
    @State
    public static class JavaArrays {
        boolean[] bs = new boolean[2];

        @Actor
        public void writer1() {
            this.bs[0] = true;
        }

        @Actor
        public void writer2() {
            this.bs[1] = true;
        }

        @Arbiter
        public void arbiter(ZZ_Result r) {
            r.r1 = this.bs[0];
            r.r2 = this.bs[1];
        }
    }
}

