/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.Ref;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.results.I_Result;
import org.openjdk.jcstress.infra.results.J_Result;
import org.openjdk.jcstress.util.UnsafeHolder;

public class JMMSample_01_AccessAtomicity {

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0"}, expect=Expect.ACCEPTABLE, desc="Seeing the default value: writer had not acted yet."), @Outcome(id={"-1"}, expect=Expect.ACCEPTABLE, desc="Seeing the full value."), @Outcome(expect=Expect.ACCEPTABLE_INTERESTING, desc="Other cases are allowed, because reads/writes are not atomic.")})
    @State
    public static class UnsafeCrossCacheLine {
        public static final int SIZE = 256;
        public static final long ARRAY_BASE_OFFSET = UnsafeHolder.U.arrayBaseOffset(byte[].class);
        public static final long ARRAY_BASE_SCALE = UnsafeHolder.U.arrayIndexScale(byte[].class);
        byte[] ss = new byte[256];
        long off = ARRAY_BASE_OFFSET + ARRAY_BASE_SCALE * (long)ThreadLocalRandom.current().nextInt(252);

        @Actor
        public void writer() {
            UnsafeHolder.U.putInt(this.ss, this.off, -1);
        }

        @Actor
        public void reader(I_Result r) {
            r.r1 = UnsafeHolder.U.getInt(this.ss, this.off);
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0"}, expect=Expect.ACCEPTABLE, desc="Seeing the default value: writer had not acted yet."), @Outcome(id={"-1"}, expect=Expect.ACCEPTABLE, desc="Seeing the full value."), @Outcome(expect=Expect.ACCEPTABLE_INTERESTING, desc="Other cases are allowed, because reads/writes are not atomic.")})
    @State
    public static class ByteBuffers {
        public static final int SIZE = 256;
        ByteBuffer bb = ByteBuffer.allocate(256);
        int idx = ThreadLocalRandom.current().nextInt(252);

        @Actor
        public void writer() {
            this.bb.putInt(this.idx, -1);
        }

        @Actor
        public void reader(I_Result r) {
            r.r1 = this.bb.getInt(this.idx);
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0"}, expect=Expect.ACCEPTABLE, desc="Seeing the default value: writer had not acted yet."), @Outcome(id={"-1"}, expect=Expect.ACCEPTABLE, desc="Seeing the full value."), @Outcome(expect=Expect.FORBIDDEN, desc="Other cases are forbidden.")})
    @State
    public static class OpaqueLongs {
        static final VarHandle VH;
        long v;

        @Actor
        public void writer() {
            VH.setOpaque(this, -1L);
        }

        @Actor
        public void reader(J_Result r) {
            r.r1 = VH.getOpaque(this);
        }

        static {
            try {
                VH = MethodHandles.lookup().findVarHandle(OpaqueLongs.class, "v", Long.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0"}, expect=Expect.ACCEPTABLE, desc="Seeing the default value: writer had not acted yet."), @Outcome(id={"-1"}, expect=Expect.ACCEPTABLE, desc="Seeing the full value."), @Outcome(expect=Expect.FORBIDDEN, desc="Other cases are forbidden.")})
    @State
    public static class VolatileLongs {
        volatile long v;

        @Actor
        public void writer() {
            this.v = -1L;
        }

        @Actor
        public void reader(J_Result r) {
            r.r1 = this.v;
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0"}, expect=Expect.ACCEPTABLE, desc="Seeing the default value: writer had not acted yet."), @Outcome(id={"-1"}, expect=Expect.ACCEPTABLE, desc="Seeing the full value."), @Outcome(expect=Expect.ACCEPTABLE_INTERESTING, desc="Other cases are violating access atomicity, but allowed under JLS.")})
    @Ref(value="https://docs.oracle.com/javase/specs/jls/se8/html/jls-17.html#jls-17.7")
    @State
    public static class Longs {
        long v;

        @Actor
        public void writer() {
            this.v = -1L;
        }

        @Actor
        public void reader(J_Result r) {
            r.r1 = this.v;
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"0"}, expect=Expect.ACCEPTABLE, desc="Seeing the default value: writer had not acted yet."), @Outcome(id={"-1"}, expect=Expect.ACCEPTABLE, desc="Seeing the full value."), @Outcome(expect=Expect.FORBIDDEN, desc="Other cases are forbidden.")})
    @State
    public static class Integers {
        int v;

        @Actor
        public void writer() {
            this.v = -1;
        }

        @Actor
        public void reader(I_Result r) {
            r.r1 = this.v;
        }
    }
}

