/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.util.concurrent.atomic.AtomicInteger;
import org.openjdk.jcstress.annotations.Actor;
import org.openjdk.jcstress.annotations.Arbiter;
import org.openjdk.jcstress.annotations.Expect;
import org.openjdk.jcstress.annotations.JCStressTest;
import org.openjdk.jcstress.annotations.Outcome;
import org.openjdk.jcstress.annotations.State;
import org.openjdk.jcstress.infra.results.I_Result;

public class ConcurrencySample_01_OperationAtomicity {

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"1"}, expect=Expect.FORBIDDEN, desc="One update lost."), @Outcome(id={"2"}, expect=Expect.ACCEPTABLE, desc="Both updates.")})
    @State
    public static class AtomicIncrement {
        AtomicInteger ai = new AtomicInteger();

        @Actor
        public void actor1() {
            this.ai.incrementAndGet();
        }

        @Actor
        public void actor2() {
            this.ai.incrementAndGet();
        }

        @Arbiter
        public void arbiter(I_Result r) {
            r.r1 = this.ai.get();
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"1"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="One update lost."), @Outcome(id={"2"}, expect=Expect.ACCEPTABLE, desc="Both updates.")})
    @State
    public static class VolatileIncrement {
        volatile int v;

        @Actor
        public void actor1() {
            ++this.v;
        }

        @Actor
        public void actor2() {
            ++this.v;
        }

        @Arbiter
        public void arbiter(I_Result r) {
            r.r1 = this.v;
        }
    }

    @JCStressTest
    @Outcome.Outcomes(value={@Outcome(id={"1"}, expect=Expect.ACCEPTABLE_INTERESTING, desc="One update lost."), @Outcome(id={"2"}, expect=Expect.ACCEPTABLE, desc="Both updates.")})
    @State
    public static class PlainIncrement {
        int v;

        @Actor
        public void actor1() {
            ++this.v;
        }

        @Actor
        public void actor2() {
            ++this.v;
        }

        @Arbiter
        public void arbiter(I_Result r) {
            r.r1 = this.v;
        }
    }
}

