/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jcstress.samples;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.runners.Runner;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.samples.APISample_03_Termination;
import org.openjdk.jcstress.util.Counter;
import org.openjdk.jcstress.vm.WhiteBoxSupport;

public class APISample_03_Termination_jcstress
extends Runner<Outcome> {
    public APISample_03_Termination_jcstress(TestConfig config, TestResultCollector collector, ExecutorService pool) {
        super(config, collector, pool, "org.openjdk.jcstress.samples.APISample_03_Termination");
    }

    public void run() {
        Counter results = new Counter();
        for (int c = 0; c < this.config.iters; ++c) {
            try {
                WhiteBoxSupport.tryDeopt((int)this.config.deoptRatio);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            this.run((Counter<Outcome>)results);
            if (results.count((Object)Outcome.STALE) > 0L) {
                this.messages.add("Have stale threads, forcing VM to exit for proper cleanup.");
                this.dump(c, results);
                System.exit(0);
                continue;
            }
            this.dump(c, results);
        }
    }

    public Counter<Outcome> sanityCheck() throws Throwable {
        throw new UnsupportedOperationException();
    }

    public Counter<Outcome> internalRun() {
        throw new UnsupportedOperationException();
    }

    private void run(Counter<Outcome> results) {
        long target = System.currentTimeMillis() + (long)this.config.time;
        while (System.currentTimeMillis() < target) {
            final APISample_03_Termination state = new APISample_03_Termination();
            final Holder holder = new Holder();
            Thread t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        holder.started = true;
                        state.actor1();
                    }
                    catch (Exception e) {
                        holder.error = true;
                    }
                    holder.terminated = true;
                }
            });
            t1.setDaemon(true);
            t1.start();
            while (!holder.started) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                state.signal();
            }
            catch (Exception e) {
                holder.error = true;
            }
            try {
                t1.join(Math.max(2 * this.config.time, 30000));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (holder.terminated) {
                if (holder.error) {
                    results.record((Object)Outcome.ERROR);
                    continue;
                }
                results.record((Object)Outcome.TERMINATED);
                continue;
            }
            results.record((Object)Outcome.STALE);
            return;
        }
    }

    public static enum Outcome {
        TERMINATED,
        STALE,
        ERROR;

    }

    private static class Holder {
        volatile boolean started;
        volatile boolean terminated;
        volatile boolean error;

        private Holder() {
        }
    }
}

