/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.lifecycle;

import com.atlassian.clover.api.CloverException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;

public abstract class MavenLifecycleAnalyzer {
    protected final LifecycleExecutor lifecycleExecutor;
    protected final MavenProject mavenProject;
    protected final MavenSession mavenSession;

    public MavenLifecycleAnalyzer(@NotNull LifecycleExecutor lifecycleExecutor, @NotNull MavenProject mavenProject, @NotNull MavenSession mavenSession) {
        this.lifecycleExecutor = lifecycleExecutor;
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
    }

    public abstract boolean isCompatibleVersion();

    public abstract Set<String> getPhasesToBeExecuted() throws CloverException;

    protected Set<String> getPhasesFromMojoExecutions(@NotNull List<MojoExecution> mojoExecutions) {
        HashSet phases = Sets.newHashSet();
        for (MojoExecution mojoExecution : mojoExecutions) {
            phases.addAll(this.getPhasesFromMojoExecution(mojoExecution));
        }
        return phases;
    }

    protected List<String> getPhasesFromMojoExecution(@NotNull MojoExecution mojoExecution) {
        String forkedPhase;
        ArrayList phases = Lists.newArrayList();
        String defaultPhase = mojoExecution.getMojoDescriptor().getPhase();
        if (defaultPhase != null) {
            phases.add(defaultPhase);
        }
        if ((forkedPhase = mojoExecution.getMojoDescriptor().getExecutePhase()) != null) {
            phases.add(forkedPhase);
        }
        return phases;
    }
}

