/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.util;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.elm.execution.CqlToElmBase;
import org.cqframework.cql.elm.execution.CqlToElmInfo;
import org.cqframework.cql.elm.execution.Library;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslatorOptionsUtil {
    protected static final Logger logger = LoggerFactory.getLogger(TranslatorOptionsUtil.class);

    private TranslatorOptionsUtil() {
    }

    public static EnumSet<CqlTranslatorOptions.Options> getTranslatorOptions(Library library) {
        Objects.requireNonNull(library, "library can not be null");
        if (library.getAnnotation() == null || library.getAnnotation().isEmpty()) {
            return null;
        }
        String translatorOptions = TranslatorOptionsUtil.getTranslatorOptions(library.getAnnotation());
        return TranslatorOptionsUtil.parseTranslatorOptions(translatorOptions);
    }

    private static String getTranslatorOptions(List<CqlToElmBase> annotations) {
        for (CqlToElmBase o : annotations) {
            if (!(o instanceof CqlToElmInfo)) continue;
            CqlToElmInfo c = (CqlToElmInfo)o;
            return c.getTranslatorOptions();
        }
        return null;
    }

    public static EnumSet<CqlTranslatorOptions.Options> parseTranslatorOptions(String translatorOptions) {
        String[] options;
        if (translatorOptions == null) {
            return null;
        }
        EnumSet<CqlTranslatorOptions.Options> optionSet = EnumSet.noneOf(CqlTranslatorOptions.Options.class);
        if (translatorOptions.trim().isEmpty()) {
            return optionSet;
        }
        for (String option : options = translatorOptions.trim().split(",")) {
            optionSet.add(CqlTranslatorOptions.Options.valueOf((String)option));
        }
        return optionSet;
    }
}

