/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.execution;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.LibraryContentType;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.elm.execution.Library;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.serializing.CqlLibraryReaderFactory;
import org.opencds.cqf.cql.evaluator.converter.VersionedIdentifierConverter;
import org.opencds.cqf.cql.evaluator.engine.elm.LibraryMapper;
import org.opencds.cqf.cql.evaluator.engine.execution.TranslatorOptionAwareLibraryLoader;
import org.opencds.cqf.cql.evaluator.engine.util.TranslatorOptionsUtil;

public class TranslatingLibraryLoader
implements TranslatorOptionAwareLibraryLoader {
    protected CqlTranslatorOptions cqlTranslatorOptions;
    protected List<LibrarySourceProvider> librarySourceProviders;
    protected LibraryManager libraryManager;

    public TranslatingLibraryLoader(ModelManager modelManager, List<LibrarySourceProvider> librarySourceProviders, CqlTranslatorOptions translatorOptions) {
        this.librarySourceProviders = Objects.requireNonNull(librarySourceProviders, "librarySourceProviders can not be null");
        this.cqlTranslatorOptions = translatorOptions != null ? translatorOptions : CqlTranslatorOptions.defaultOptions();
        this.libraryManager = new LibraryManager(modelManager);
        for (LibrarySourceProvider provider : librarySourceProviders) {
            this.libraryManager.getLibrarySourceLoader().registerProvider(provider);
        }
    }

    public Library load(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        Library library = this.getLibraryFromElm(libraryIdentifier);
        if (library != null && this.translatorOptionsMatch(library).booleanValue()) {
            return library;
        }
        return this.translate(libraryIdentifier);
    }

    @Override
    public CqlTranslatorOptions getCqlTranslatorOptions() {
        return this.cqlTranslatorOptions;
    }

    protected Library getLibraryFromElm(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        VersionedIdentifier versionedIdentifier = VersionedIdentifierConverter.toElmIdentifier(libraryIdentifier);
        for (LibraryContentType type : List.of(LibraryContentType.JSON, LibraryContentType.XML)) {
            InputStream is = this.getLibraryContent(versionedIdentifier, type);
            if (is == null) continue;
            try {
                return CqlLibraryReaderFactory.getReader((String)type.mimeType()).read(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Boolean translatorOptionsMatch(Library library) {
        EnumSet<CqlTranslatorOptions.Options> options = TranslatorOptionsUtil.getTranslatorOptions(library);
        if (options == null) {
            return false;
        }
        return options.equals(this.cqlTranslatorOptions.getOptions());
    }

    protected InputStream getLibraryContent(VersionedIdentifier libraryIdentifier, LibraryContentType libraryContentType) {
        for (LibrarySourceProvider librarySourceProvider : this.librarySourceProviders) {
            InputStream content = librarySourceProvider.getLibraryContent(libraryIdentifier, libraryContentType);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    protected Library translate(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        CompiledLibrary library = null;
        ArrayList errors = new ArrayList();
        try {
            library = this.libraryManager.resolveLibrary(VersionedIdentifierConverter.toElmIdentifier(libraryIdentifier), this.cqlTranslatorOptions, errors);
        }
        catch (Exception e) {
            throw new CqlException(String.format("Unable translate library %s", libraryIdentifier.getId()), (Throwable)e);
        }
        if (!errors.isEmpty()) {
            for (CqlCompilerException e : errors) {
                if (e.getSeverity() != CqlCompilerException.ErrorSeverity.Error) continue;
                throw new CqlException(String.format("Translation of library %s failed with the following message: %s", libraryIdentifier.getId(), e.getMessage()));
            }
        }
        try {
            return LibraryMapper.INSTANCE.map(library.getLibrary());
        }
        catch (Exception e) {
            throw new CqlException(String.format("Mapping of library %s failed", libraryIdentifier.getId()), (Throwable)e);
        }
    }
}

