/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.execution;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.elm.execution.Library;
import org.cqframework.cql.elm.execution.VersionedIdentifier;
import org.opencds.cqf.cql.evaluator.engine.execution.TranslatorOptionAwareLibraryLoader;
import org.opencds.cqf.cql.evaluator.engine.util.TranslatorOptionsUtil;

public class CacheAwareLibraryLoaderDecorator
implements TranslatorOptionAwareLibraryLoader {
    private TranslatorOptionAwareLibraryLoader innerLoader;
    private Map<VersionedIdentifier, Library> libraryCache = new HashMap<VersionedIdentifier, Library>();

    public CacheAwareLibraryLoaderDecorator(TranslatorOptionAwareLibraryLoader libraryLoader, Map<VersionedIdentifier, Library> libraryCache) {
        this.innerLoader = libraryLoader;
        this.libraryCache = libraryCache == null ? new HashMap<VersionedIdentifier, Library>() : libraryCache;
    }

    public CacheAwareLibraryLoaderDecorator(TranslatorOptionAwareLibraryLoader libraryLoader) {
        this(libraryLoader, null);
    }

    public Library load(VersionedIdentifier libraryIdentifier) {
        Library library = this.libraryCache.get(libraryIdentifier);
        if (library != null && this.translatorOptionsMatch(library).booleanValue()) {
            return library;
        }
        library = this.innerLoader.load(libraryIdentifier);
        if (library == null) {
            return null;
        }
        this.libraryCache.put(libraryIdentifier, library);
        return library;
    }

    protected Boolean translatorOptionsMatch(Library library) {
        EnumSet<CqlTranslatorOptions.Options> options = TranslatorOptionsUtil.getTranslatorOptions(library);
        if (options == null) {
            return false;
        }
        return options.equals(this.getCqlTranslatorOptions().getOptions());
    }

    @Override
    public CqlTranslatorOptions getCqlTranslatorOptions() {
        return this.innerLoader.getCqlTranslatorOptions();
    }

    public Map<VersionedIdentifier, Library> getLibraryCache() {
        return this.libraryCache;
    }
}

