/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.terminology;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.ArrayList;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.cql.engine.exception.TerminologyProviderException;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class R4FhirTerminologyProvider
implements TerminologyProvider {
    private static final String URN_UUID = "urn:uuid:";
    private static final String URN_OID = "urn:oid:";
    private static final String VALUE_SET = "ValueSet";
    private IGenericClient fhirClient;

    public R4FhirTerminologyProvider() {
    }

    public R4FhirTerminologyProvider(IGenericClient fhirClient) {
        this.fhirClient = fhirClient;
    }

    public IGenericClient getFhirClient() {
        return this.fhirClient;
    }

    public boolean in(Code code, ValueSetInfo valueSet) {
        try {
            String id = this.resolveValueSetId(valueSet);
            Parameters respParam = code.getSystem() != null ? (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType(VALUE_SET, id))).named("validate-code").withParameter(Parameters.class, "code", (IBase)new StringType(code.getCode())).andParameter("system", (IBase)new StringType(code.getSystem())).useHttpGet().execute() : (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType(VALUE_SET, id))).named("validate-code").withParameter(Parameters.class, "code", (IBase)new StringType(code.getCode())).useHttpGet().execute();
            return ((BooleanType)((Parameters.ParametersParameterComponent)respParam.getParameter().get(0)).getValue()).booleanValue();
        }
        catch (Exception e) {
            throw new TerminologyProviderException(String.format("Error performing membership check of Code: %s in ValueSet: %s", code.toString(), valueSet.getId()), (Throwable)e);
        }
    }

    public Iterable<Code> expand(ValueSetInfo valueSet) {
        try {
            String id = this.resolveValueSetId(valueSet);
            Parameters respParam = (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType(VALUE_SET, id))).named("expand").withNoParameters(Parameters.class).useHttpGet().execute();
            ValueSet expanded = (ValueSet)((Parameters.ParametersParameterComponent)respParam.getParameter().get(0)).getResource();
            ArrayList<Code> codes = new ArrayList<Code>();
            for (ValueSet.ValueSetExpansionContainsComponent codeInfo : expanded.getExpansion().getContains()) {
                Code nextCode = new Code().withCode(codeInfo.getCode()).withSystem(codeInfo.getSystem()).withVersion(codeInfo.getVersion()).withDisplay(codeInfo.getDisplay());
                codes.add(nextCode);
            }
            return codes;
        }
        catch (Exception e) {
            throw new TerminologyProviderException(String.format("Error performing expansion of ValueSet: %s", valueSet.getId()), (Throwable)e);
        }
    }

    public Code lookup(Code code, CodeSystemInfo codeSystem) {
        try {
            Parameters respParam = (Parameters)((IOperationUnnamed)this.fhirClient.operation().onType(CodeSystem.class)).named("lookup").withParameter(Parameters.class, "code", (IBase)new CodeType(code.getCode())).andParameter("system", (IBase)new UriType(codeSystem.getId())).execute();
            StringType display = (StringType)respParam.getParameter("display");
            if (display != null) {
                code.withDisplay((String)display.getValue());
            }
            return code.withSystem(codeSystem.getId());
        }
        catch (Exception e) {
            throw new TerminologyProviderException(String.format("Error performing lookup of Code: %s in CodeSystem: %s", code.toString(), codeSystem.getId()), (Throwable)e);
        }
    }

    protected Bundle searchByUrl(String url) {
        return (Bundle)this.fhirClient.search().forResource(ValueSet.class).where(ValueSet.URL.matches().value(url)).returnBundle(Bundle.class).execute();
    }

    protected Bundle searchByIdentifier(String identifier) {
        return (Bundle)this.fhirClient.search().forResource(ValueSet.class).where(ValueSet.IDENTIFIER.exactly().code(identifier)).returnBundle(Bundle.class).execute();
    }

    protected Bundle searchById(String id) {
        if (id.startsWith(URN_OID)) {
            id = id.replace(URN_OID, "");
        } else if (id.startsWith(URN_UUID)) {
            id = id.replace(URN_UUID, "");
        }
        Bundle searchResults = new Bundle();
        if (id.matches("[A-Za-z0-9\\-\\.]{1,64}")) {
            try {
                ValueSet vs = (ValueSet)this.fhirClient.read().resource(ValueSet.class).withId(id).execute();
                searchResults.addEntry().setResource((Resource)vs);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
        }
        return searchResults;
    }

    public String resolveValueSetId(ValueSetInfo valueSet) {
        if (valueSet.getVersion() != null || valueSet.getCodeSystems() != null && !valueSet.getCodeSystems().isEmpty()) {
            throw new UnsupportedOperationException(String.format("Could not expand value set %s; version and code system bindings are not supported at this time.", valueSet.getId()));
        }
        Bundle searchResults = this.searchByUrl(valueSet.getId());
        if (!searchResults.hasEntry()) {
            searchResults = this.searchByIdentifier(valueSet.getId());
        }
        if (!searchResults.hasEntry()) {
            searchResults = this.searchById(valueSet.getId());
        }
        if (!searchResults.hasEntry() || searchResults.getEntry().isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not resolve value set %s.", valueSet.getId()));
        }
        if (searchResults.getEntry().size() > 1) {
            throw new IllegalArgumentException("Found more than 1 ValueSet with url: " + valueSet.getId());
        }
        return searchResults.getEntryFirstRep().getResource().getIdElement().getIdPart();
    }
}

