/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.github.curiousoddman.rgxgen.RgxGen;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPythonCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractPythonCodegen.class);
    protected String packageName = "openapi_client";
    protected String packageVersion = "1.0.0";
    protected String projectName;

    public AbstractPythonCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("all_params", "resource_path", "path_params", "query_params", "header_params", "form_params", "local_var_files", "body_params", "auth_settings", "property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "nonlocal", "None", "True", "False", "async", "await"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("list");
        this.languageSpecificPrimitives.add("dict");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.languageSpecificPrimitives.add("date");
        this.languageSpecificPrimitives.add("object");
        this.languageSpecificPrimitives.add("file");
        this.languageSpecificPrimitives.add("bytes");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("set", "list");
        this.typeMapping.put("map", "dict");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("AnyType", "object");
        this.typeMapping.put("file", "file");
        this.typeMapping.put("binary", "str");
        this.typeMapping.put("ByteArray", "str");
        this.typeMapping.put("UUID", "str");
        this.typeMapping.put("URI", "str");
        this.typeMapping.put("null", "none_type");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PYTHON_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable PYTHON_POST_PROCESS_FILE not defined so the Python code may not be properly formatted. To define it, try 'export PYTHON_POST_PROCESS_FILE=\"/usr/local/bin/yapf -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "(str, " + this.getTypeDeclaration(inner) + ")";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                if (!Boolean.valueOf(p.getDefault().toString()).booleanValue()) {
                    return "False";
                }
                return "True";
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p)) {
                if (p.getDefault() != null) {
                    if (Pattern.compile("\r\n|\r|\n").matcher((String)p.getDefault()).find()) {
                        return "'''" + p.getDefault() + "'''";
                    }
                    return "'" + ((String)p.getDefault()).replace("'", "'") + "'";
                }
            } else if (ModelUtils.isArraySchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("$", "")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase(Locale.ROOT);
        }
        name = StringUtils.underscore(name);
        if (this.isReservedWord(name = name.replaceAll("^_*", "")) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "param_callback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.underscore(this.sanitizeName(operationId));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("'''", "'_'_'");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String pythonPostProcessFile = System.getenv("PYTHON_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pythonPostProcessFile)) {
            return;
        }
        if ("py".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = pythonPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String toExampleValue(Schema schema) {
        return this.toExampleValueRecursive(schema, new ArrayList<String>(), 5);
    }

    private String toExampleValueRecursive(Schema schema, List<String> includedSchemas, int indentation) {
        String indentationString = "";
        for (int i = 0; i < indentation; ++i) {
            indentationString = indentationString + "    ";
        }
        String example = null;
        if (schema.getExample() != null) {
            example = schema.getExample().toString();
        }
        if (ModelUtils.isNullType(schema) && null != example) {
            return "None";
        }
        if (ModelUtils.isBooleanSchema(schema) && null != example) {
            example = "false".equalsIgnoreCase(example) ? "False" : "True";
        }
        if (ModelUtils.isStringSchema(schema) && schema.getDefault() != null && !ModelUtils.isDateSchema(schema) && !ModelUtils.isDateTimeSchema(schema)) {
            example = (String)schema.getDefault();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)example) && !"null".equals(example)) {
            if (ModelUtils.isStringSchema(schema)) {
                example = "'" + example + "'";
            }
            return example;
        }
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            example = schema.getEnum().get(0).toString();
            if (ModelUtils.isStringSchema(schema)) {
                example = "'" + this.escapeText(example) + "'";
            }
            if (null == example) {
                this.LOGGER.warn("Empty enum. Cannot built an example!");
            }
            return example;
        }
        if (null != schema.get$ref()) {
            Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
            String ref = ModelUtils.getSimpleRef(schema.get$ref());
            if (allDefinitions != null) {
                Schema refSchema = allDefinitions.get(ref);
                if (null == refSchema) {
                    return "None";
                }
                String refTitle = refSchema.getTitle();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)refTitle) || "null".equals(refTitle)) {
                    refSchema.setTitle(ref);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                    includedSchemas.add(schema.getTitle());
                }
                return this.toExampleValueRecursive(refSchema, includedSchemas, indentation);
            }
            this.LOGGER.warn("allDefinitions not defined in toExampleValue!\n");
        }
        if (ModelUtils.isDateSchema(schema)) {
            example = "datetime.datetime.strptime('1975-12-30', '%Y-%m-%d').date()";
            return example;
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            example = "datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f')";
            return example;
        }
        if (ModelUtils.isBinarySchema(schema)) {
            example = "bytes(b'blah')";
            return example;
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            example = "YQ==";
        } else if (ModelUtils.isStringSchema(schema)) {
            if ("Number".equalsIgnoreCase(schema.getFormat())) {
                return "1";
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getPattern())) {
                String pattern = schema.getPattern();
                RgxGen rgxGen = new RgxGen((CharSequence)this.patternCorrection(pattern));
                Random random = new Random(18L);
                String sample = rgxGen.generate(random);
                Pattern valueExtractor = Pattern.compile("^/\\^?(.+?)\\$?/.?$");
                Matcher m = valueExtractor.matcher(sample);
                example = m.find() ? m.group(m.groupCount()) : sample;
            }
            if (example == null) {
                example = "";
            }
            int len = 0;
            if (null != schema.getMinLength()) {
                len = schema.getMinLength();
                if (len < 1) {
                    example = "";
                } else {
                    for (int i = 0; i < len; ++i) {
                        example = example + i;
                    }
                }
            }
        } else if (ModelUtils.isIntegerSchema(schema)) {
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "56";
        } else if (ModelUtils.isNumberSchema(schema)) {
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "1.337";
        } else if (ModelUtils.isBooleanSchema(schema)) {
            example = "True";
        } else if (ModelUtils.isArraySchema(schema)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                includedSchemas.add(schema.getTitle());
            }
            ArraySchema arrayschema = (ArraySchema)schema;
            example = "[\n" + indentationString + this.toExampleValueRecursive(arrayschema.getItems(), includedSchemas, indentation + 1) + "\n" + indentationString + "]";
        } else if (ModelUtils.isMapSchema(schema)) {
            Object additionalObject;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                includedSchemas.add(schema.getTitle());
            }
            if ((additionalObject = schema.getAdditionalProperties()) instanceof Schema) {
                Schema additional = (Schema)additionalObject;
                String theKey = "'key'";
                if (additional.getEnum() != null && !additional.getEnum().isEmpty()) {
                    theKey = additional.getEnum().get(0).toString();
                    if (ModelUtils.isStringSchema(additional)) {
                        theKey = "'" + this.escapeText(theKey) + "'";
                    }
                }
                example = "{\n" + indentationString + theKey + " : " + this.toExampleValueRecursive(additional, includedSchemas, indentation + 1) + "\n" + indentationString + "}";
            } else {
                example = "{ }";
            }
        } else if (ModelUtils.isObjectSchema(schema)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)schema.getTitle())) {
                example = "None";
                return example;
            }
            String toExclude = null;
            if (schema.getDiscriminator() != null) {
                toExclude = schema.getDiscriminator().getPropertyName();
            }
            example = this.packageName + ".models." + StringUtils.underscore(schema.getTitle()) + "." + schema.getTitle() + "(";
            ArrayList<String> reqs = new ArrayList<String>();
            if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                for (Object toAdd : schema.getProperties().keySet()) {
                    reqs.add((String)toAdd);
                }
                Map properties = schema.getProperties();
                Set propkeys = null;
                if (properties != null) {
                    propkeys = properties.keySet();
                }
                if (toExclude != null && reqs.contains(toExclude)) {
                    reqs.remove(toExclude);
                }
                for (String toRemove : includedSchemas) {
                    if (!reqs.contains(toRemove)) continue;
                    reqs.remove(toRemove);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                    includedSchemas.add(schema.getTitle());
                }
                if (null != schema.getRequired()) {
                    for (String toAdd : schema.getRequired()) {
                        reqs.add(toAdd);
                    }
                }
                if (null != propkeys) {
                    for (String propname : propkeys) {
                        Schema schema2 = (Schema)properties.get(propname);
                        if (!reqs.contains(propname)) continue;
                        String refTitle = schema2.getTitle();
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)refTitle) || "null".equals(refTitle)) {
                            schema2.setTitle(propname);
                        }
                        example = example + "\n" + indentationString + StringUtils.underscore(propname) + " = " + this.toExampleValueRecursive(schema2, includedSchemas, indentation + 1) + ", ";
                    }
                }
            }
            example = example + ")";
        } else {
            this.LOGGER.warn("Type {} not handled properly in toExampleValue", (Object)schema.getType());
        }
        if (ModelUtils.isStringSchema(schema)) {
            example = "'" + this.escapeText(example) + "'";
        }
        return example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type) || "str".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("file".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = this.packageName + "." + type + "()";
        } else {
            this.LOGGER.warn("Type {} not handled properly in setParameterExampleValue", (Object)type);
        }
        if (example == null) {
            example = "None";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            example = "[" + example + "]";
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "{'key': " + example + "}";
        }
        p.example = example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Schema schema = parameter.getSchema();
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
        } else if (parameter.getExamples() != null && !parameter.getExamples().isEmpty()) {
            Example example = (Example)parameter.getExamples().values().iterator().next();
            if (example.getValue() != null) {
                codegenParameter.example = example.getValue().toString();
            }
        } else if (schema != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
        }
        this.setParameterExampleValue(codegenParameter);
    }

    @Override
    public String sanitizeTag(String tag) {
        return this.sanitizeName(tag);
    }

    public String patternCorrection(String pattern) {
        boolean checkEnding;
        boolean bl = checkEnding = pattern.endsWith("/i") || pattern.endsWith("/g") || pattern.endsWith("/m");
        if (checkEnding) {
            pattern = pattern.substring(0, pattern.length() - 2);
        }
        if (pattern.endsWith("/")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (pattern.startsWith("/")) {
            pattern = pattern.substring(1);
        }
        return pattern;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.additionalProperties.put("packageName", this.packageName);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(openAPIType);
        }
        return type;
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)name, (Object)StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(AbstractPythonCodegen.dropDots(this.toModelName(name)));
    }

    @Override
    public String toModelTestFilename(String name) {
        return "test_" + this.toModelFilename(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name + "_" + this.apiNameSuffix);
    }

    @Override
    public String toApiTestFilename(String name) {
        return "test_" + this.toApiFilename(name);
    }

    @Override
    public String toApiName(String name) {
        return super.toApiName(name);
    }

    @Override
    public String toApiVarName(String name) {
        if (name.length() == 0) {
            return "default_api";
        }
        return StringUtils.underscore(name + "_" + this.apiNameSuffix);
    }

    protected static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.PYTHON;
    }
}

