/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelUtils.class);

    public static CodegenModel getModelByName(String name, Map<String, Object> models) {
        Map dataMap;
        Object dataModels;
        Object data = models.get(name);
        if (data instanceof Map && (dataModels = (dataMap = (Map)data).get("models")) instanceof List) {
            List dataModelsList = (List)dataModels;
            for (Object entry : dataModelsList) {
                Map entryMap;
                Object model;
                if (!(entry instanceof Map) || !((model = (entryMap = (Map)entry).get("model")) instanceof CodegenModel)) continue;
                return (CodegenModel)model;
            }
        }
        return null;
    }

    public static List<String> getAllUsedSchemas(OpenAPI openAPI) {
        ArrayList<String> allUsedSchemas = new ArrayList<String>();
        ModelUtils.visitOpenAPI(openAPI, (s, t) -> {
            String ref;
            if (s.get$ref() != null && !allUsedSchemas.contains(ref = ModelUtils.getSimpleRef(s.get$ref()))) {
                allUsedSchemas.add(ref);
            }
        });
        return allUsedSchemas;
    }

    public static List<String> getUnusedSchemas(OpenAPI openAPI) {
        ArrayList<String> unusedSchemas = new ArrayList<String>();
        Map<String, Schema> schemas = ModelUtils.getSchemas(openAPI);
        unusedSchemas.addAll(schemas.keySet());
        ModelUtils.visitOpenAPI(openAPI, (s, t) -> {
            if (s.get$ref() != null) {
                unusedSchemas.remove(ModelUtils.getSimpleRef(s.get$ref()));
            }
        });
        return unusedSchemas;
    }

    public static List<String> getSchemasUsedOnlyInFormParam(OpenAPI openAPI) {
        ArrayList schemasUsedInFormParam = new ArrayList();
        ArrayList schemasUsedInOtherCases = new ArrayList();
        ModelUtils.visitOpenAPI(openAPI, (s, t) -> {
            if (s.get$ref() != null) {
                String ref = ModelUtils.getSimpleRef(s.get$ref());
                if ("application/x-www-form-urlencoded".equalsIgnoreCase(t) || "multipart/form-data".equalsIgnoreCase(t)) {
                    schemasUsedInFormParam.add(ref);
                } else {
                    schemasUsedInOtherCases.add(ref);
                }
            }
        });
        return schemasUsedInFormParam.stream().filter(n -> !schemasUsedInOtherCases.contains(n)).collect(Collectors.toList());
    }

    private static void visitOpenAPI(OpenAPI openAPI, OpenAPISchemaVisitor visitor) {
        Paths paths = openAPI.getPaths();
        ArrayList<String> visitedSchemas = new ArrayList<String>();
        if (paths != null) {
            for (PathItem path : paths.values()) {
                ModelUtils.visitPathItem(path, openAPI, visitor, visitedSchemas);
            }
        }
    }

    private static void visitPathItem(PathItem pathItem, OpenAPI openAPI, OpenAPISchemaVisitor visitor, List<String> visitedSchemas) {
        List allOperations = pathItem.readOperations();
        if (allOperations != null) {
            for (Operation operation : allOperations) {
                RequestBody requestBody;
                if (operation.getParameters() != null) {
                    for (Parameter p : operation.getParameters()) {
                        Parameter parameter = ModelUtils.getReferencedParameter(openAPI, p);
                        if (parameter.getSchema() == null) continue;
                        ModelUtils.visitSchema(openAPI, parameter.getSchema(), null, visitedSchemas, visitor);
                    }
                }
                if ((requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody())) != null && requestBody.getContent() != null) {
                    for (Map.Entry e : requestBody.getContent().entrySet()) {
                        if (((MediaType)e.getValue()).getSchema() == null) continue;
                        ModelUtils.visitSchema(openAPI, ((MediaType)e.getValue()).getSchema(), (String)e.getKey(), visitedSchemas, visitor);
                    }
                }
                if (operation.getResponses() != null) {
                    for (ApiResponse r : operation.getResponses().values()) {
                        ApiResponse apiResponse = ModelUtils.getReferencedApiResponse(openAPI, r);
                        if (apiResponse == null || apiResponse.getContent() == null) continue;
                        for (Map.Entry e : apiResponse.getContent().entrySet()) {
                            if (((MediaType)e.getValue()).getSchema() == null) continue;
                            ModelUtils.visitSchema(openAPI, ((MediaType)e.getValue()).getSchema(), (String)e.getKey(), visitedSchemas, visitor);
                        }
                    }
                }
                if (operation.getCallbacks() == null) continue;
                for (Callback c : operation.getCallbacks().values()) {
                    Callback callback = ModelUtils.getReferencedCallback(openAPI, c);
                    if (callback == null) continue;
                    for (PathItem p : callback.values()) {
                        ModelUtils.visitPathItem(p, openAPI, visitor, visitedSchemas);
                    }
                }
            }
        }
    }

    private static void visitSchema(OpenAPI openAPI, Schema schema, String mimeType, List<String> visitedSchemas, OpenAPISchemaVisitor visitor) {
        Map properties;
        Object additionalProperties;
        String ref;
        visitor.visit(schema, mimeType);
        if (schema.get$ref() != null && !visitedSchemas.contains(ref = ModelUtils.getSimpleRef(schema.get$ref()))) {
            visitedSchemas.add(ref);
            Schema referencedSchema = ModelUtils.getSchemas(openAPI).get(ref);
            if (referencedSchema != null) {
                ModelUtils.visitSchema(openAPI, referencedSchema, mimeType, visitedSchemas, visitor);
            }
        }
        if (schema instanceof ComposedSchema) {
            List anyOf;
            List allOf;
            List oneOf = ((ComposedSchema)schema).getOneOf();
            if (oneOf != null) {
                for (Schema s : oneOf) {
                    ModelUtils.visitSchema(openAPI, s, mimeType, visitedSchemas, visitor);
                }
            }
            if ((allOf = ((ComposedSchema)schema).getAllOf()) != null) {
                for (Schema s : allOf) {
                    ModelUtils.visitSchema(openAPI, s, mimeType, visitedSchemas, visitor);
                }
            }
            if ((anyOf = ((ComposedSchema)schema).getAnyOf()) != null) {
                for (Schema s : anyOf) {
                    ModelUtils.visitSchema(openAPI, s, mimeType, visitedSchemas, visitor);
                }
            }
        } else if (schema instanceof ArraySchema) {
            Schema itemsSchema = ((ArraySchema)schema).getItems();
            if (itemsSchema != null) {
                ModelUtils.visitSchema(openAPI, itemsSchema, mimeType, visitedSchemas, visitor);
            }
        } else if (ModelUtils.isMapSchema(schema) && (additionalProperties = schema.getAdditionalProperties()) instanceof Schema) {
            ModelUtils.visitSchema(openAPI, (Schema)additionalProperties, mimeType, visitedSchemas, visitor);
        }
        if (schema.getNot() != null) {
            ModelUtils.visitSchema(openAPI, schema.getNot(), mimeType, visitedSchemas, visitor);
        }
        if ((properties = schema.getProperties()) != null) {
            for (Schema property : properties.values()) {
                ModelUtils.visitSchema(openAPI, property, mimeType, visitedSchemas, visitor);
            }
        }
    }

    public static String getSimpleRef(String ref) {
        if (ref.startsWith("#/components/")) {
            ref = ref.substring(ref.lastIndexOf("/") + 1);
        } else if (ref.startsWith("#/definitions/")) {
            ref = ref.substring(ref.lastIndexOf("/") + 1);
        } else {
            LOGGER.warn("Failed to get the schema name: {}", (Object)ref);
            return null;
        }
        return ref;
    }

    public static boolean isObjectSchema(Schema schema) {
        if (schema instanceof ObjectSchema) {
            return true;
        }
        if ("object".equals(schema.getType()) && !(schema instanceof MapSchema)) {
            return true;
        }
        return schema.getType() == null && schema.getProperties() != null && !schema.getProperties().isEmpty();
    }

    public static boolean isComposedSchema(Schema schema) {
        return schema instanceof ComposedSchema;
    }

    public static boolean isMapSchema(Schema schema) {
        if (schema instanceof MapSchema) {
            return true;
        }
        if (schema.getAdditionalProperties() instanceof Schema) {
            return true;
        }
        return schema.getAdditionalProperties() instanceof Boolean && (Boolean)schema.getAdditionalProperties() != false;
    }

    public static boolean isArraySchema(Schema schema) {
        if (schema instanceof ArraySchema) {
            return true;
        }
        return schema.getMaxItems() != null || schema.getMinItems() != null;
    }

    public static boolean isStringSchema(Schema schema) {
        return schema instanceof StringSchema || "string".equals(schema.getType());
    }

    public static boolean isIntegerSchema(Schema schema) {
        if (schema instanceof IntegerSchema) {
            return true;
        }
        return "integer".equals(schema.getType());
    }

    public static boolean isShortchema(Schema schema) {
        return "integer".equals(schema.getType()) && "int32".equals(schema.getFormat());
    }

    public static boolean isLongSchema(Schema schema) {
        return "integer".equals(schema.getType()) && "int64".equals(schema.getFormat());
    }

    public static boolean isBooleanSchema(Schema schema) {
        if (schema instanceof BooleanSchema) {
            return true;
        }
        return "boolean".equals(schema.getType());
    }

    public static boolean isNumberSchema(Schema schema) {
        if (schema instanceof NumberSchema) {
            return true;
        }
        return "number".equals(schema.getType());
    }

    public static boolean isFloatSchema(Schema schema) {
        return "number".equals(schema.getType()) && "float".equals(schema.getFormat());
    }

    public static boolean isDoubleSchema(Schema schema) {
        if (schema instanceof NumberSchema) {
            return true;
        }
        return "number".equals(schema.getType()) && "double".equals(schema.getFormat());
    }

    public static boolean isDateSchema(Schema schema) {
        if (schema instanceof DateSchema) {
            return true;
        }
        return "string".equals(schema.getType()) && "date".equals(schema.getFormat());
    }

    public static boolean isDateTimeSchema(Schema schema) {
        if (schema instanceof DateTimeSchema) {
            return true;
        }
        return "string".equals(schema.getType()) && "date-time".equals(schema.getFormat());
    }

    public static boolean isPasswordSchema(Schema schema) {
        if (schema instanceof PasswordSchema) {
            return true;
        }
        return "string".equals(schema.getType()) && "password".equals(schema.getFormat());
    }

    public static boolean isByteArraySchema(Schema schema) {
        if (schema instanceof ByteArraySchema) {
            return true;
        }
        return "string".equals(schema.getType()) && "byte".equals(schema.getFormat());
    }

    public static boolean isBinarySchema(Schema schema) {
        if (schema instanceof BinarySchema) {
            return true;
        }
        return "string".equals(schema.getType()) && "binary".equals(schema.getFormat());
    }

    public static boolean isFileSchema(Schema schema) {
        if (schema instanceof FileSchema) {
            return true;
        }
        return ModelUtils.isBinarySchema(schema);
    }

    public static boolean isUUIDSchema(Schema schema) {
        if (schema instanceof UUIDSchema) {
            return true;
        }
        return "string".equals(schema.getType()) && "uuid".equals(schema.getFormat());
    }

    public static boolean isEmailSchema(Schema schema) {
        if (schema instanceof EmailSchema) {
            return true;
        }
        return "string".equals(schema.getType()) && "email".equals(schema.getFormat());
    }

    public static boolean isModel(Schema schema) {
        if (schema == null) {
            LOGGER.error("Schema cannot be null in isModel check");
            return false;
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            return true;
        }
        return schema instanceof ComposedSchema;
    }

    public static boolean isFreeFormObject(Schema schema) {
        if (schema == null) {
            LOGGER.error("Schema cannot be null in isFreeFormObject check");
            return false;
        }
        if ("object".equals(schema.getType()) && (schema.getProperties() == null || schema.getProperties().isEmpty())) {
            if (schema.getAdditionalProperties() == null) {
                return true;
            }
            if (schema.getAdditionalProperties() instanceof Boolean && ((Boolean)schema.getAdditionalProperties()).booleanValue()) {
                return true;
            }
            if (schema.getAdditionalProperties() instanceof Schema && schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof ObjectSchema && ((Schema)schema.getAdditionalProperties()).getProperties().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public static Schema getReferencedSchema(OpenAPI openAPI, Schema schema) {
        String name;
        Schema referencedSchema;
        if (schema != null && StringUtils.isNotEmpty((CharSequence)schema.get$ref()) && (referencedSchema = ModelUtils.getSchema(openAPI, name = ModelUtils.getSimpleRef(schema.get$ref()))) != null) {
            return referencedSchema;
        }
        return schema;
    }

    public static Schema getSchema(OpenAPI openAPI, String name) {
        if (name == null) {
            return null;
        }
        return ModelUtils.getSchemas(openAPI).get(name);
    }

    public static Map<String, Schema> getSchemas(OpenAPI openAPI) {
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            return openAPI.getComponents().getSchemas();
        }
        return Collections.emptyMap();
    }

    public static RequestBody getReferencedRequestBody(OpenAPI openAPI, RequestBody requestBody) {
        String name;
        RequestBody referencedRequestBody;
        if (requestBody != null && StringUtils.isNotEmpty((CharSequence)requestBody.get$ref()) && (referencedRequestBody = ModelUtils.getRequestBody(openAPI, name = ModelUtils.getSimpleRef(requestBody.get$ref()))) != null) {
            return referencedRequestBody;
        }
        return requestBody;
    }

    public static RequestBody getRequestBody(OpenAPI openAPI, String name) {
        if (name == null) {
            return null;
        }
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getRequestBodies() != null) {
            return (RequestBody)openAPI.getComponents().getRequestBodies().get(name);
        }
        return null;
    }

    public static ApiResponse getReferencedApiResponse(OpenAPI openAPI, ApiResponse apiResponse) {
        String name;
        ApiResponse referencedApiResponse;
        if (apiResponse != null && StringUtils.isNotEmpty((CharSequence)apiResponse.get$ref()) && (referencedApiResponse = ModelUtils.getApiResponse(openAPI, name = ModelUtils.getSimpleRef(apiResponse.get$ref()))) != null) {
            return referencedApiResponse;
        }
        return apiResponse;
    }

    public static ApiResponse getApiResponse(OpenAPI openAPI, String name) {
        if (name == null) {
            return null;
        }
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getResponses() != null) {
            return (ApiResponse)openAPI.getComponents().getResponses().get(name);
        }
        return null;
    }

    public static Parameter getReferencedParameter(OpenAPI openAPI, Parameter parameter) {
        String name;
        Parameter referencedParameter;
        if (parameter != null && StringUtils.isNotEmpty((CharSequence)parameter.get$ref()) && (referencedParameter = ModelUtils.getParameter(openAPI, name = ModelUtils.getSimpleRef(parameter.get$ref()))) != null) {
            return referencedParameter;
        }
        return parameter;
    }

    public static Parameter getParameter(OpenAPI openAPI, String name) {
        if (name == null) {
            return null;
        }
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getParameters() != null) {
            return (Parameter)openAPI.getComponents().getParameters().get(name);
        }
        return null;
    }

    public static Callback getReferencedCallback(OpenAPI openAPI, Callback callback) {
        String name;
        Callback referencedCallback;
        if (callback != null && StringUtils.isNotEmpty((CharSequence)callback.get$ref()) && (referencedCallback = ModelUtils.getCallback(openAPI, name = ModelUtils.getSimpleRef(callback.get$ref()))) != null) {
            return referencedCallback;
        }
        return callback;
    }

    public static Callback getCallback(OpenAPI openAPI, String name) {
        if (name == null) {
            return null;
        }
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getCallbacks() != null) {
            return (Callback)openAPI.getComponents().getCallbacks().get(name);
        }
        return null;
    }

    public static Schema getSchemaFromRequestBody(RequestBody requestBody) {
        return ModelUtils.getSchemaFromContent(requestBody.getContent());
    }

    public static Schema getSchemaFromResponse(ApiResponse response) {
        return ModelUtils.getSchemaFromContent(response.getContent());
    }

    private static Schema getSchemaFromContent(Content content) {
        if (content == null || content.isEmpty()) {
            return null;
        }
        if (content.size() > 1) {
            LOGGER.warn("Multiple schemas found, returning only the first one");
        }
        MediaType mediaType = (MediaType)content.values().iterator().next();
        return mediaType.getSchema();
    }

    public static Schema unaliasSchema(Map<String, Schema> allSchemas, Schema schema) {
        if (allSchemas == null || allSchemas.isEmpty()) {
            return schema;
        }
        if (schema != null && StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            Schema ref = allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref()));
            if (ref == null) {
                LOGGER.warn("{} is not defined", (Object)schema.get$ref());
                return schema;
            }
            if (ref.getEnum() != null && !ref.getEnum().isEmpty()) {
                return schema;
            }
            if (ModelUtils.isFreeFormObject(ref)) {
                return schema;
            }
            if (ModelUtils.isArraySchema(ref)) {
                return ModelUtils.unaliasSchema(allSchemas, allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())));
            }
            if (ModelUtils.isComposedSchema(ref)) {
                return schema;
            }
            if (ModelUtils.isMapSchema(ref)) {
                if (ref.getProperties() != null && !ref.getProperties().isEmpty()) {
                    return schema;
                }
                return ModelUtils.unaliasSchema(allSchemas, allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())));
            }
            if (ModelUtils.isObjectSchema(ref)) {
                return schema;
            }
            return ModelUtils.unaliasSchema(allSchemas, allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())));
        }
        return schema;
    }

    public static Schema getAdditionalProperties(Schema schema) {
        if (schema.getAdditionalProperties() instanceof Schema) {
            return (Schema)schema.getAdditionalProperties();
        }
        if (schema.getAdditionalProperties() instanceof Boolean && ((Boolean)schema.getAdditionalProperties()).booleanValue()) {
            return new ObjectSchema();
        }
        return null;
    }

    public static Header getReferencedHeader(OpenAPI openAPI, Header header) {
        String name;
        Header referencedheader;
        if (header != null && StringUtils.isNotEmpty((CharSequence)header.get$ref()) && (referencedheader = ModelUtils.getHeader(openAPI, name = ModelUtils.getSimpleRef(header.get$ref()))) != null) {
            return referencedheader;
        }
        return header;
    }

    public static Header getHeader(OpenAPI openAPI, String name) {
        if (name == null) {
            return null;
        }
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getHeaders() != null) {
            return (Header)openAPI.getComponents().getHeaders().get(name);
        }
        return null;
    }

    @FunctionalInterface
    private static interface OpenAPISchemaVisitor {
        public void visit(Schema var1, String var2);
    }
}

