/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerlClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerlClientCodegen.class);
    public static final String MODULE_NAME = "moduleName";
    public static final String MODULE_VERSION = "moduleVersion";
    protected String moduleName = "WWW::OpenAPIClient";
    protected String modulePathPart = this.moduleName.replaceAll("::", Matcher.quoteReplacement(File.separator));
    protected String moduleVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected static int emptyFunctionNameCounter = 0;

    public PerlClientCodegen() {
        this.importMapping.clear();
        this.modelPackage = File.separatorChar + "Object";
        this.outputFolder = "generated-code" + File.separatorChar + "perl";
        this.modelTemplateFiles.put("object.mustache", ".pm");
        this.apiTemplateFiles.put("api.mustache", ".pm");
        this.modelTestTemplateFiles.put("object_test.mustache", ".t");
        this.apiTestTemplateFiles.put("api_test.mustache", ".t");
        this.modelDocTemplateFiles.put("object_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "perl";
        this.embeddedTemplateDir = "perl";
        this.setReservedWordsLowerCase(Arrays.asList("else", "lock", "qw", "__END__", "elsif", "lt", "qx", "__FILE__", "eq", "m", "s", "__LINE__", "exp", "ne", "sub", "__PACKAGE__", "for", "no", "tr", "and", "foreach", "or", "unless", "cmp", "ge", "package", "until", "continue", "gt", "q", "while", "CORE", "if", "qq", "xor", "do", "le", "qr", "y", "return"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("double");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("boolean");
        this.languageSpecificPrimitives.add("DateTime");
        this.languageSpecificPrimitives.add("ARRAY");
        this.languageSpecificPrimitives.add("HASH");
        this.languageSpecificPrimitives.add("object");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("array", "ARRAY");
        this.typeMapping.put("map", "HASH");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("file", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption(MODULE_NAME, "Perl module name (convention: CamelCase or Long::Module).").defaultValue("OpenAPIClient"));
        this.cliOptions.add(new CliOption(MODULE_VERSION, "Perl module version.").defaultValue("1.0.0"));
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("ensureUniqueParams", "Whether to ensure parameter names are unique in an operation (rename parameters that are not).").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("prependFormOrBodyParameters", "Add form or body parameters to the beginning of the parameter list.").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PERL_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable PERL_POST_PROCESS_FILE not defined so the Perl code may not be properly formatted. To define it, try 'export PERL_POST_PROCESS_FILE=/usr/local/bin/perltidy -b -bext=\"/\"' (Linux/Mac)");
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(MODULE_VERSION)) {
            this.setModuleVersion((String)this.additionalProperties.get(MODULE_VERSION));
        } else {
            this.additionalProperties.put(MODULE_VERSION, this.moduleVersion);
        }
        if (this.additionalProperties.containsKey(MODULE_NAME)) {
            this.setModuleName((String)this.additionalProperties.get(MODULE_NAME));
            this.setModulePathPart(this.moduleName.replaceAll("::", Matcher.quoteReplacement(File.separator)));
        } else {
            this.additionalProperties.put(MODULE_NAME, this.moduleName);
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", ("lib/" + this.modulePathPart).replace('/', File.separatorChar), "ApiClient.pm"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", ("lib/" + this.modulePathPart).replace('/', File.separatorChar), "Configuration.pm"));
        this.supportingFiles.add(new SupportingFile("ApiFactory.mustache", ("lib/" + this.modulePathPart).replace('/', File.separatorChar), "ApiFactory.pm"));
        this.supportingFiles.add(new SupportingFile("Role.mustache", ("lib/" + this.modulePathPart).replace('/', File.separatorChar), "Role.pm"));
        this.supportingFiles.add(new SupportingFile("AutoDoc.mustache", ("lib/" + this.modulePathPart + "/Role").replace('/', File.separatorChar), "AutoDoc.pm"));
        this.supportingFiles.add(new SupportingFile("autodoc.script.mustache", "bin", "autodoc"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "perl";
    }

    @Override
    public String getHelp() {
        return "Generates a Perl client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/lib/" + this.modulePathPart + this.apiPackage()).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/lib/" + this.modulePathPart + this.modelPackage()).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputFolder + "/t").replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputFolder + "/t").replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
                return "'" + p.getDefault() + "'";
            }
        }
        return null;
    }

    @Override
    public String toVarName(String name) {
        if ((name = StringUtils.underscore(name)).matches("^\\d.*")) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "Test";
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "Test";
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiFilename(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.camelize(name) + "Api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return StringUtils.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            operationId = StringUtils.underscore("empty_function_name_" + emptyFunctionNameCounter++);
            LOGGER.warn("Empty method name (operationId) found. Renamed to " + operationId);
            return operationId;
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            return StringUtils.underscore(this.sanitizeName("call_" + operationId));
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.underscore(this.sanitizeName(operationId));
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setModulePathPart(String modulePathPart) {
        this.modulePathPart = modulePathPart;
    }

    public void setModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if (Boolean.TRUE.equals(p.isInteger)) {
            if (example == null) {
                example = "56";
            }
        } else if (Boolean.TRUE.equals(p.isLong)) {
            if (example == null) {
                example = "789";
            }
        } else if (Boolean.TRUE.equals(p.isDouble) || Boolean.TRUE.equals(p.isFloat) || Boolean.TRUE.equals(p.isNumber)) {
            if (example == null) {
                example = "3.4";
            }
        } else if (Boolean.TRUE.equals(p.isBoolean)) {
            p.example = Boolean.parseBoolean(p.example) ? "1" : "0";
        } else if (Boolean.TRUE.equals(p.isFile) || Boolean.TRUE.equals(p.isBinary)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (Boolean.TRUE.equals(p.isByteArray)) {
            if (example == null) {
                example = "YmFzZSA2NCBkYXRh";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "DateTime->from_epoch(epoch => str2time('" + this.escapeText(p.example) + "'))";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "DateTime->from_epoch(epoch => str2time('" + this.escapeText(p.example) + "'))";
        } else if (Boolean.TRUE.equals(p.isString)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + this.moduleName + "." + type + "()";
        }
        if (Boolean.TRUE.equals(p.isListContainer)) {
            example = this.setPropertyExampleValue(p.items);
            example = "(" + example + ")";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = this.setPropertyExampleValue(p.items);
            example = "('key' =>  " + example + "}";
        } else if (example == null) {
            example = "null";
        }
        p.example = example;
    }

    protected String setPropertyExampleValue(CodegenProperty p) {
        if (p == null) {
            return "null";
        }
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if (Boolean.TRUE.equals(p.isInteger)) {
            if (example == null) {
                example = "56";
            }
        } else if (Boolean.TRUE.equals(p.isLong)) {
            if (example == null) {
                example = "789";
            }
        } else if (Boolean.TRUE.equals(p.isDouble) || Boolean.TRUE.equals(p.isFloat) || Boolean.TRUE.equals(p.isNumber)) {
            if (example == null) {
                example = "3.4";
            }
        } else if (Boolean.TRUE.equals(p.isBoolean)) {
            if (example == null) {
                example = "true";
            }
        } else if (Boolean.TRUE.equals(p.isFile) || Boolean.TRUE.equals(p.isBinary)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "DateTime->from_epoch(epoch => str2time('" + this.escapeText(p.example) + "'))";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "DateTime->from_epoch(epoch => str2time('" + this.escapeText(p.example) + "'))";
        } else if (Boolean.TRUE.equals(p.isString)) {
            if (example == null) {
                example = p.name + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + this.moduleName + "." + type + "()";
        }
        return example;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=begin", "=_begin").replace("=end", "=_end").replace("=cut", "=_cut").replace("=pod", "=_pod");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String perlTidyPath = System.getenv("PERL_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)perlTidyPath)) {
            return;
        }
        if ("t".equals(FilenameUtils.getExtension((String)file.toString())) || "pm".equals(FilenameUtils.getExtension((String)file.toString())) || "pl".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = perlTidyPath + " -b -bext='/' " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

