/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.spring;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringBeanNameResolver
implements BeanNameResolver {
    private final Logger log = Logger.getLogger(SpringBeanNameResolver.class);

    public String getBeanName(Class<?> clazz) {
        WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
        if (context == null) {
            throw new IllegalStateException("Unable to get current WebApplicationContext");
        }
        Set<String> beanNames = this.resolveBeanNames((ListableBeanFactory)context, clazz);
        if (beanNames == null || beanNames.size() == 0) {
            return null;
        }
        if (beanNames.size() > 1) {
            this.log.warn("Spring knows more than one bean of type [{}]", (Object)clazz.getName());
            return null;
        }
        return beanNames.iterator().next();
    }

    private Set<String> resolveBeanNames(ListableBeanFactory beanFactory, Class<?> clazz) {
        HashSet<String> result = new HashSet<String>();
        Map beanMap = beanFactory.getBeansOfType(clazz);
        if (beanMap != null) {
            for (String name : beanMap.keySet()) {
                if (name == null || name.startsWith("scopedTarget.")) continue;
                result.add(name);
            }
        }
        return result;
    }
}

