/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.generator.service;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.noear.weed.generator.mapper.JavaCodeBlock;
import org.noear.weed.generator.mapper.TypeBlock;
import org.noear.weed.generator.mapper.XmlSqlBlock;
import org.noear.weed.generator.mapper.XmlSqlVar;
import org.noear.weed.generator.utils.IOUtils;
import org.noear.weed.generator.utils.StringUtils;
import org.noear.weed.generator.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSqlServiceGenerator {
    public static void generate(File baseDir, File sourceDir) {
        try {
            String path = baseDir.getAbsolutePath() + "/src/main/resources/weed3";
            File dic = new File(path);
            XmlSqlServiceGenerator.generate0(dic, sourceDir);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void generate0(File file, File sourceDir) throws Throwable {
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                XmlSqlServiceGenerator.generate0(tmp, sourceDir);
            }
        } else if (file.getName().endsWith(".xml")) {
            XmlSqlServiceGenerator.generateJavaFile(sourceDir, file);
        }
    }

    public static void generateJavaFile(File sourceDir, File xmlFile) throws Exception {
        JavaCodeBlock block = XmlSqlServiceGenerator.parse(xmlFile);
        if (block == null) {
            return;
        }
        String dic_path = sourceDir.getAbsolutePath() + "/" + block._packageName.replace(".", "/");
        new File(dic_path).mkdirs();
        String file_path = dic_path + "/" + block._className + ".java";
        File file = new File(file_path);
        if (file.exists()) {
            System.err.println("[Weed] Warning : " + file.getAbsolutePath());
            return;
        }
        file.createNewFile();
        IOUtils.fileWrite(file, block._code);
        System.out.println("[Weed] Generated : " + file.getAbsolutePath());
    }

    public static JavaCodeBlock parse(File xmlFile) throws Exception {
        if (xmlFile == null) {
            return null;
        }
        Document doc = XmlUtils.parseDoc(xmlFile);
        Element nm = doc.getDocumentElement();
        HashSet<String> importSet = new HashSet<String>();
        String namespace = XmlUtils.attr(nm, "proxy");
        if (namespace == null || namespace.length() == 0) {
            return null;
        }
        String mapper = XmlUtils.attr(nm, "namespace");
        String _import = XmlUtils.attr(nm, "import");
        int sepindex = namespace.lastIndexOf(46);
        String packagename = namespace.substring(0, sepindex);
        String classname = namespace.substring(sepindex + 1);
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(packagename).append(";\n\n");
        sb.append("import java.math.*;\n");
        sb.append("import java.sql.SQLException;\n");
        sb.append("import java.time.*;\n");
        sb.append("import java.util.*;\n\n");
        sb.append("import org.noear.solon.annotation.Inject;\n");
        sb.append("import org.noear.solon.extend.aspect.annotation.Service;\n");
        sb.append("import org.noear.weed.DataItem;\n");
        sb.append("import org.noear.weed.DataList;\n");
        sb.append("import org.noear.weed.annotation.Db;\n");
        if (!StringUtils.isEmpty(_import)) {
            String[] ss;
            for (String s : ss = _import.split(";")) {
                if (s.length() <= 2) continue;
                sb.append("import ").append(s).append(";\n");
            }
        }
        sb.append("\n");
        StringBuilder sb2 = new StringBuilder();
        HashMap<String, Node> node_map = new HashMap<String, Node>();
        NodeList sql_list = doc.getElementsByTagName("sql");
        int len = sql_list.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = sql_list.item(i);
            String id = XmlUtils.attr(n, "id");
            if (id == null) continue;
            node_map.put(id, n);
        }
        sb2.append("@Service\n");
        sb2.append("public class ").append(classname);
        sb2.append("{\n");
        sb2.append("    @Inject\n");
        sb2.append("    ").append(mapper).append(" mapper;\n");
        StringBuilder sb_tmp = new StringBuilder();
        int len2 = sql_list.getLength();
        for (int i = 0; i < len2; ++i) {
            Node n = sql_list.item(i);
            XmlSqlBlock block = XmlSqlServiceGenerator.parseSqlNode(node_map, sb_tmp, n, namespace, classname);
            XmlSqlServiceGenerator.writerBlock(sb2, block);
            if (i < len2 - 1) {
                sb2.append("\n");
            }
            importSet.addAll(block.impTypeSet);
        }
        sb2.append("\n}\n");
        for (String type : importSet.stream().sorted().collect(Collectors.toList())) {
            sb.append("import ").append(type).append(";\n");
        }
        if (importSet.size() > 0) {
            XmlSqlServiceGenerator.newLine(sb, 0);
        }
        sb.append((CharSequence)sb2);
        node_map.clear();
        JavaCodeBlock codeBlock = new JavaCodeBlock();
        codeBlock._namespace = namespace;
        codeBlock._packageName = packagename;
        codeBlock._className = classname;
        codeBlock._code = sb.toString();
        return codeBlock;
    }

    private static void writerBlock(StringBuilder sb, XmlSqlBlock block) {
        XmlSqlVar v;
        if (block._remarks != null && block._remarks.length() > 0) {
            XmlSqlServiceGenerator.newLine(sb, 2).append("//").append(block._remarks);
        }
        XmlSqlServiceGenerator.newLine(sb, 2);
        sb.append("public ");
        if (StringUtils.isEmpty(block._return)) {
            sb.append("void");
        } else if ("Map".equals(block._return)) {
            sb.append("Map<String,Object>");
        } else if ("MapList".equals(block._return)) {
            sb.append("List<Map<String,Object>>");
        } else {
            sb.append(block._return);
        }
        sb.append(" ").append(block._id).append("(");
        for (String k : block.varMap.keySet()) {
            v = block.varMap.get(k);
            sb.append(v.type).append(" ").append(v.name).append(", ");
        }
        if (block.varMap.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(") throws SQLException{");
        XmlSqlServiceGenerator.newLine(sb, 4);
        sb.append("return mapper.").append(block._id).append("(");
        for (String k : block.varMap.keySet()) {
            v = block.varMap.get(k);
            sb.append(v.name).append(",");
        }
        if (block.varMap.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(");");
        XmlSqlServiceGenerator.newLine(sb, 2);
        sb.append("}");
    }

    private static XmlSqlBlock parseSqlNode(Map<String, Node> nodeMap, StringBuilder sb, Node n, String namespace, String classname) {
        int depth = 1;
        XmlSqlBlock dblock = new XmlSqlBlock();
        dblock.__nodeMap = nodeMap;
        dblock._namespace = namespace;
        dblock._className = classname;
        dblock._classCode = sb;
        dblock._id = XmlUtils.attr(n, "id");
        dblock._remarks = XmlUtils.attr(n, ":remarks");
        if (dblock._remarks == null) {
            dblock._remarks = XmlUtils.attr(n, ":note");
        }
        dblock._param = XmlUtils.attr(n, ":param");
        dblock._declare = XmlUtils.attr(n, ":declare");
        dblock._return = XmlUtils.attr(n, ":return");
        if (dblock._return != null) {
            TypeBlock tBlock = new TypeBlock(dblock._return);
            dblock._return = tBlock.newType;
            if (tBlock.impType != null) {
                dblock.impTypeSet.add(tBlock.impType);
            }
        }
        dblock._caching = XmlUtils.attr(n, ":caching");
        dblock._usingCache = XmlUtils.attr(n, ":usingCache");
        dblock._cacheTag = XmlUtils.attr(n, ":cacheTag");
        dblock._cacheClear = XmlUtils.attr(n, ":cacheClear");
        XmlSqlServiceGenerator._parseDeclare(dblock);
        XmlSqlServiceGenerator.newLine(sb, depth).append("public SQLBuilder ").append(dblock._id).append("(Map map){");
        StringBuilder sb2 = new StringBuilder();
        XmlSqlServiceGenerator.newLine(sb2, depth + 1).append("SQLBuilder sb = new SQLBuilder();\n");
        XmlSqlServiceGenerator._parseNodeList(n.getChildNodes(), sb2, dblock, depth + 1);
        int var_num = 0;
        for (XmlSqlVar dv : dblock.varMap.values()) {
            if (dv.type == null || dv.type.length() <= 0) continue;
            ++var_num;
            XmlSqlServiceGenerator.newLine(sb, depth + 1).append(dv.type).append(" ").append(dv.name).append("=").append("(").append(dv.type).append(")map.get(\"").append(dv.name).append("\");");
        }
        if (var_num > 0) {
            sb.append("\n");
        }
        sb.append((CharSequence)sb2);
        sb.append("\n");
        XmlSqlServiceGenerator.newLine(sb, depth + 1).append("return sb;");
        XmlSqlServiceGenerator.newLine(sb, depth).append("}\n");
        dblock.__nodeMap = null;
        return dblock;
    }

    private static void _parseDeclare(XmlSqlBlock dblock) {
        XmlSqlVar dv;
        String[] kv;
        String tmp;
        int i;
        int len;
        String[] ss;
        if (dblock._param != null) {
            ss = dblock._param.split(",");
            len = ss.length;
            for (i = 0; i < len; ++i) {
                tmp = ss[i].trim();
                if (tmp.indexOf(":") <= 0 || tmp.length() <= 3) continue;
                kv = tmp.split(":");
                dv = new XmlSqlVar(tmp, kv[0].trim(), kv[1].trim());
                dblock.varPut(dv);
            }
        }
        if (dblock._declare != null) {
            ss = dblock._declare.split(",");
            len = ss.length;
            for (i = 0; i < len; ++i) {
                tmp = ss[i].trim();
                if (tmp.indexOf(":") <= 0 || tmp.length() <= 3) continue;
                kv = tmp.split(":");
                dv = new XmlSqlVar(tmp, kv[0].trim(), kv[1].trim());
                dblock.varPut(dv);
            }
        }
    }

    private static void _parseNodeList(NodeList nl, StringBuilder sb, XmlSqlBlock dblock, int depth) {
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            XmlSqlServiceGenerator._parseNode(n, sb, dblock, depth);
        }
    }

    private static void _parseNode(Node n, StringBuilder sb, XmlSqlBlock dblock, int depth) {
        String text;
        short type = n.getNodeType();
        if ((type == 3 || type == 4) && (text = n.getTextContent().trim()).length() > 0) {
            XmlSqlServiceGenerator.newLine(sb, depth).append("sb.append(");
            XmlSqlServiceGenerator.parseTxt(sb, dblock, text);
            sb.append(");");
        }
        if (type == 1) {
            String tagName = n.getNodeName();
            if ("if".equals(tagName)) {
                XmlSqlServiceGenerator.parseIfNode(sb, dblock, n, depth);
                return;
            }
            if ("for".equals(tagName)) {
                XmlSqlServiceGenerator.parseForNode(sb, dblock, n, depth);
                return;
            }
            if ("ref".equals(tagName)) {
                XmlSqlServiceGenerator.parseRefNode(sb, dblock, n, depth);
                return;
            }
            XmlSqlServiceGenerator._parseNodeList(n.getChildNodes(), sb, dblock, depth);
        }
    }

    private static void parseIfNode(StringBuilder sb, XmlSqlBlock dblock, Node n, int depth) {
        String _test = XmlUtils.attr(n, "test");
        XmlSqlServiceGenerator.newLine(sb, depth).append("if(").append(_test).append("){");
        XmlSqlServiceGenerator._parseNodeList(n.getChildNodes(), sb, dblock, depth + 1);
        XmlSqlServiceGenerator.newLine(sb, depth).append("}");
    }

    private static void parseRefNode(StringBuilder sb, XmlSqlBlock dblock, Node n, int depth) {
        String _sql_id = XmlUtils.attr(n, "sql");
        if (!StringUtils.isEmpty(_sql_id)) {
            Node ref_n = dblock.__nodeMap.get(_sql_id);
            if (ref_n == null) {
                throw new RuntimeException("sql node @" + _sql_id + " can't find");
            }
            XmlSqlServiceGenerator._parseNode(ref_n, sb, dblock, depth);
        }
    }

    private static void parseForNode(StringBuilder sb, XmlSqlBlock dblock, Node n, int depth) {
        String _var_str = XmlUtils.attr(n, "var").trim();
        if (_var_str.indexOf(":") < 0 || _var_str.length() < 3) {
            StringBuilder eb = new StringBuilder();
            eb.append(dblock._namespace).append("/").append(dblock._id).append("::").append("for/var(").append(_var_str).append(") must declare the type");
            throw new RuntimeException(eb.toString());
        }
        String[] kv = _var_str.split(":");
        XmlSqlVar _var = new XmlSqlVar(_var_str, kv[0].trim(), kv[1].trim());
        String _items = XmlUtils.attr(n, "items");
        XmlSqlServiceGenerator.newLine(sb, depth).append("for(").append(_var.type).append(" ").append(_var.name).append(" : ").append(_items).append("){");
        XmlSqlServiceGenerator._parseNodeList(n.getChildNodes(), sb, dblock, depth + 1);
        if (_items.indexOf(".") < 0) {
            XmlSqlVar _itemsVar = new XmlSqlVar(_items, _items, "Collection<" + _var.type + ">");
            dblock.varPut(_itemsVar);
        }
        XmlSqlServiceGenerator.newLine(sb, depth).append("}");
    }

    private static StringBuilder newLine(StringBuilder sb, int depth) {
        sb.append("\n");
        while (depth > 0) {
            sb.append("  ");
            --depth;
        }
        return sb;
    }

    private static void parseTxt(StringBuilder sb, XmlSqlBlock dblock, String txt0) {
        String[] kv;
        Object dv;
        String txt2 = null;
        LinkedHashMap<String, Object> tmpList = new LinkedHashMap<String, Object>();
        txt2 = txt0.replace("\n", " ").replace("\"", "\\\"");
        tmpList.clear();
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher m = pattern.matcher(txt2);
        while (m.find()) {
            dv = new XmlSqlVar();
            ((XmlSqlVar)dv).mark = m.group(0);
            ((XmlSqlVar)dv).name = m.group(1).trim().replace("[", "<").replace("]", ">");
            if (((XmlSqlVar)dv).name.indexOf(":") > 0) {
                kv = ((XmlSqlVar)dv).name.split(":");
                ((XmlSqlVar)dv).name = kv[0].trim();
                ((XmlSqlVar)dv).type = kv[1].trim();
            }
            tmpList.put(((XmlSqlVar)dv).name, dv);
            dblock.varPut((XmlSqlVar)dv);
        }
        for (XmlSqlVar dv2 : tmpList.values()) {
            txt2 = txt2.replace(dv2.mark, "\"+" + dv2.name + "+\"");
        }
        tmpList.clear();
        pattern = Pattern.compile("@\\{(.+?)\\}");
        m = pattern.matcher(txt2);
        while (m.find()) {
            dv = new XmlSqlVar();
            ((XmlSqlVar)dv).mark = m.group(0);
            ((XmlSqlVar)dv).name = m.group(1).trim().replace("[", "<").replace("]", ">");
            if (((XmlSqlVar)dv).name.indexOf(":") > 0) {
                kv = ((XmlSqlVar)dv).name.split(":");
                ((XmlSqlVar)dv).name = kv[0].trim();
                ((XmlSqlVar)dv).type = kv[1].trim();
            }
            tmpList.put(((XmlSqlVar)dv).name, dv);
            dblock.varPut((XmlSqlVar)dv);
        }
        for (XmlSqlVar dv2 : tmpList.values()) {
            if (dv2.type != null && dv2.type.indexOf(">") > 0) {
                txt2 = txt2.replace(dv2.mark, "?...");
                continue;
            }
            txt2 = txt2.replace(dv2.mark, "?");
        }
        sb.append("\"").append(txt2).append(" \"");
        for (String k : tmpList.keySet()) {
            XmlSqlVar v = (XmlSqlVar)tmpList.get(k);
            sb.append(",").append(v.name);
        }
    }
}

