/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query.join;

import java.util.List;
import org.elasticsearch.client.Client;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.JoinSelect;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.TableOnJoinSelect;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.DefaultQueryAction;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.SqlElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.JoinRequestBuilder;
import org.nlpcn.es4sql.query.join.TableInJoinRequestBuilder;

public abstract class ESJoinQueryAction
extends QueryAction {
    protected JoinSelect joinSelect;

    public ESJoinQueryAction(Client client, JoinSelect joinSelect) {
        super(client, null);
        this.joinSelect = joinSelect;
    }

    @Override
    public SqlElasticRequestBuilder explain() throws SqlParseException {
        JoinRequestBuilder requestBuilder = this.createSpecificBuilder();
        this.fillBasicJoinRequestBuilder(requestBuilder);
        this.fillSpecificRequestBuilder(requestBuilder);
        return requestBuilder;
    }

    protected abstract void fillSpecificRequestBuilder(JoinRequestBuilder var1) throws SqlParseException;

    protected abstract JoinRequestBuilder createSpecificBuilder();

    private void fillBasicJoinRequestBuilder(JoinRequestBuilder requestBuilder) throws SqlParseException {
        this.fillTableInJoinRequestBuilder(requestBuilder.getFirstTable(), this.joinSelect.getFirstTable());
        this.fillTableInJoinRequestBuilder(requestBuilder.getSecondTable(), this.joinSelect.getSecondTable());
        requestBuilder.setJoinType(this.joinSelect.getJoinType());
        requestBuilder.setTotalLimit(this.joinSelect.getTotalLimit());
        this.updateRequestWithHints(requestBuilder);
    }

    protected void updateRequestWithHints(JoinRequestBuilder requestBuilder) {
        for (Hint hint : this.joinSelect.getHints()) {
            if (hint.getType() != HintType.JOIN_LIMIT) continue;
            Object[] params = hint.getParams();
            requestBuilder.getFirstTable().setHintLimit((Integer)params[0]);
            requestBuilder.getSecondTable().setHintLimit((Integer)params[1]);
        }
    }

    private void fillTableInJoinRequestBuilder(TableInJoinRequestBuilder requestBuilder, TableOnJoinSelect tableOnJoinSelect) throws SqlParseException {
        List<Field> connectedFields = tableOnJoinSelect.getConnectedFields();
        this.addFieldsToSelectIfMissing(tableOnJoinSelect, connectedFields);
        requestBuilder.setOriginalSelect(tableOnJoinSelect);
        DefaultQueryAction queryAction = new DefaultQueryAction(this.client, tableOnJoinSelect);
        queryAction.explain();
        requestBuilder.setRequestBuilder(queryAction.getRequestBuilder());
        requestBuilder.setReturnedFields(tableOnJoinSelect.getSelectedFields());
        requestBuilder.setAlias(tableOnJoinSelect.getAlias());
    }

    private void addFieldsToSelectIfMissing(Select select, List<Field> fields) {
        if (select.getFields() == null || select.getFields().size() == 0) {
            return;
        }
        List<Field> selectedFields = select.getFields();
        for (Field field : fields) {
            if (selectedFields.contains(field)) continue;
            selectedFields.add(field);
        }
    }
}

