/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.join.aggregations.ChildrenAggregationBuilder;
import org.elasticsearch.join.aggregations.JoinAggregationBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregatorBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.MaxBucketPipelineAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Order;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.DefaultQueryAction;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.SqlElasticSearchRequestBuilder;
import org.nlpcn.es4sql.query.maker.AggMaker;
import org.nlpcn.es4sql.query.maker.QueryMaker;

public class AggregationQueryAction
extends QueryAction {
    private final Select select;
    private AggMaker aggMaker = new AggMaker();
    private SearchRequestBuilder request;

    public AggregationQueryAction(Client client, Select select) {
        super(client, select);
        this.select = select;
    }

    @Override
    public SqlElasticSearchRequestBuilder explain() throws SqlParseException {
        this.request = new SearchRequestBuilder((ElasticsearchClient)this.client, SearchAction.INSTANCE);
        ArrayList bucketFields = Lists.newArrayList();
        List<Field> _fields = this.select.getFields().stream().filter(field -> {
            if (field.getName().startsWith("max_bucket") || field.getName().startsWith("min_bucket")) {
                bucketFields.add(field);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        this.select.setFields(_fields);
        if (bucketFields.size() > 0) {
            bucketFields.stream().forEach(field -> {
                String bucketPath = ((MethodField)field).getParams().get(0).toString().replace("=", ">");
                MaxBucketPipelineAggregationBuilder pipAgg = null;
                if (field.getName().equals("max_bucket")) {
                    pipAgg = PipelineAggregatorBuilders.maxBucket((String)field.getAlias(), (String)bucketPath);
                } else if (field.getName().equals("min_bucket")) {
                    pipAgg = PipelineAggregatorBuilders.minBucket((String)field.getAlias(), (String)bucketPath);
                }
                if (null != pipAgg) {
                    this.request.addAggregation((PipelineAggregationBuilder)pipAgg);
                }
            });
        }
        this.setIndicesAndTypes();
        this.setWhere(this.select.getWhere());
        AggregationBuilder lastAgg = null;
        for (List<Field> groupBy : this.select.getGroupBys()) {
            if (!groupBy.isEmpty()) {
                Field field2 = groupBy.get(0);
                lastAgg = this.getGroupAgg(field2, this.select);
                if (lastAgg != null && lastAgg instanceof TermsAggregationBuilder && !(field2 instanceof MethodField)) {
                    if (this.select.getRowCount() < 200) {
                        ((TermsAggregationBuilder)lastAgg).shardSize(5000);
                        for (Hint hint : this.select.getHints()) {
                            if (hint.getType() != HintType.SHARD_SIZE || hint.getParams() == null || hint.getParams().length == 0 || hint.getParams()[0] == null) continue;
                            ((TermsAggregationBuilder)lastAgg).shardSize(((Integer)hint.getParams()[0]).intValue());
                        }
                    }
                    this.setSize(lastAgg, field2);
                    this.setShardSize(lastAgg);
                }
                if (field2.isNested()) {
                    AggregationBuilder nestedBuilder = this.createNestedAggregation(field2);
                    if (this.insertFilterIfExistsAfter(lastAgg, groupBy, nestedBuilder, 1)) {
                        groupBy.remove(1);
                    } else {
                        nestedBuilder.subAggregation(lastAgg);
                    }
                    this.request.addAggregation(this.wrapNestedIfNeeded(nestedBuilder, field2.isReverseNested()));
                } else if (field2.isChildren()) {
                    AggregationBuilder childrenBuilder = this.createChildrenAggregation(field2);
                    if (this.insertFilterIfExistsAfter(lastAgg, groupBy, childrenBuilder, 1)) {
                        groupBy.remove(1);
                    } else {
                        childrenBuilder.subAggregation(lastAgg);
                    }
                    this.request.addAggregation(childrenBuilder);
                } else {
                    this.request.addAggregation(lastAgg);
                }
                for (int i = 1; i < groupBy.size(); ++i) {
                    field2 = (Field)groupBy.get(i);
                    AggregationBuilder subAgg = this.getGroupAgg(field2, this.select);
                    this.setSize(subAgg, field2);
                    this.setShardSize(subAgg);
                    if (field2.isNested()) {
                        AggregationBuilder nestedBuilder = this.createNestedAggregation(field2);
                        if (this.insertFilterIfExistsAfter(subAgg, groupBy, nestedBuilder, i + 1)) {
                            groupBy.remove(i + 1);
                            ++i;
                        } else {
                            nestedBuilder.subAggregation(subAgg);
                        }
                        lastAgg.subAggregation(this.wrapNestedIfNeeded(nestedBuilder, field2.isReverseNested()));
                    } else if (field2.isChildren()) {
                        AggregationBuilder childrenBuilder = this.createChildrenAggregation(field2);
                        if (this.insertFilterIfExistsAfter(subAgg, groupBy, childrenBuilder, i + 1)) {
                            groupBy.remove(i + 1);
                            ++i;
                        } else {
                            childrenBuilder.subAggregation(subAgg);
                        }
                        lastAgg.subAggregation(childrenBuilder);
                    } else {
                        lastAgg.subAggregation(subAgg);
                    }
                    lastAgg = subAgg;
                }
            }
            this.explanFields(this.request, this.select.getFields(), lastAgg);
        }
        if (this.select.getGroupBys().size() < 1) {
            this.explanFields(this.request, this.select.getFields(), lastAgg);
        }
        Map<String, KVValue> groupMap = this.aggMaker.getGroupMap();
        if (this.select.getFields().size() > 0) {
            this.setFields(this.select.getFields());
        }
        if (lastAgg != null && this.select.getOrderBys().size() > 0) {
            for (Order order : this.select.getOrderBys()) {
                KVValue temp = groupMap.get(order.getName());
                if (temp != null) {
                    String orderName;
                    TermsAggregationBuilder aggsBuilder;
                    if (temp.value instanceof TermsAggregationBuilder) {
                        aggsBuilder = (TermsAggregationBuilder)temp.value;
                        switch (temp.key) {
                            case "COUNT": {
                                orderName = order.getName();
                                if (this.isAliasFiled(orderName)) {
                                    aggsBuilder.order(BucketOrder.aggregation((String)orderName, (boolean)this.isASC(order)));
                                    break;
                                }
                                aggsBuilder.order(BucketOrder.count((boolean)this.isASC(order)));
                                break;
                            }
                            case "KEY": {
                                aggsBuilder.order(BucketOrder.key((boolean)this.isASC(order)));
                                this.request.addSort(order.getName(), SortOrder.valueOf((String)order.getType()));
                                break;
                            }
                            case "FIELD": {
                                aggsBuilder.order(BucketOrder.aggregation((String)order.getName(), (boolean)this.isASC(order)));
                                break;
                            }
                            default: {
                                throw new SqlParseException(order.getName() + " can not to order");
                            }
                        }
                        continue;
                    }
                    if (!(temp.value instanceof DateHistogramAggregationBuilder)) continue;
                    aggsBuilder = (DateHistogramAggregationBuilder)temp.value;
                    switch (temp.key) {
                        case "COUNT": {
                            orderName = order.getName();
                            if (this.isAliasFiled(orderName)) {
                                aggsBuilder.order(BucketOrder.aggregation((String)orderName, (boolean)this.isASC(order)));
                                break;
                            }
                            aggsBuilder.order(BucketOrder.count((boolean)this.isASC(order)));
                            break;
                        }
                        case "KEY": {
                            aggsBuilder.order(BucketOrder.key((boolean)this.isASC(order)));
                            this.request.addSort(order.getName(), SortOrder.valueOf((String)order.getType()));
                            break;
                        }
                        case "FIELD": {
                            aggsBuilder.order(BucketOrder.aggregation((String)order.getName(), (boolean)this.isASC(order)));
                            break;
                        }
                        default: {
                            throw new SqlParseException(order.getName() + " can not to order");
                        }
                    }
                    continue;
                }
                this.request.addSort(order.getName(), SortOrder.valueOf((String)order.getType()));
            }
        }
        this.setLimitFromHint(this.select.getHints());
        this.request.setSearchType(SearchType.DEFAULT);
        this.updateRequestWithIndexAndRoutingOptions(this.select, this.request);
        this.updateRequestWithHighlight(this.select, this.request);
        this.updateRequestWithCollapse(this.select, this.request);
        this.updateRequestWithPostFilter(this.select, this.request);
        this.updateRequestWithStats(this.select, this.request);
        this.updateRequestWithPreference(this.select, this.request);
        this.updateRequestWithTrackTotalHits(this.select, this.request);
        this.updateRequestWithTimeout(this.select, this.request);
        this.updateRequestWithIndicesOptions(this.select, this.request);
        this.updateRequestWithMinScore(this.select, this.request);
        SqlElasticSearchRequestBuilder sqlElasticRequestBuilder = new SqlElasticSearchRequestBuilder((ActionRequestBuilder)this.request);
        return sqlElasticRequestBuilder;
    }

    private void setSize(AggregationBuilder agg, Field field) {
        if (field instanceof MethodField) {
            MethodField mf = (MethodField)field;
            Object customSize = mf.getParamsAsMap().get("size");
            if (customSize == null && this.select.getRowCount() > 0 && agg instanceof TermsAggregationBuilder) {
                ((TermsAggregationBuilder)agg).size(this.select.getRowCount());
            }
        } else if (this.select.getRowCount() > 0 && agg instanceof TermsAggregationBuilder) {
            ((TermsAggregationBuilder)agg).size(this.select.getRowCount());
        }
    }

    private void setShardSize(AggregationBuilder agg) {
        if (agg instanceof TermsAggregationBuilder) {
            int defaultShardSize = 20 * this.select.getRowCount();
            ((TermsAggregationBuilder)agg).shardSize(Math.max(defaultShardSize, 5000));
        }
    }

    private AggregationBuilder getGroupAgg(Field field, Select select2) throws SqlParseException {
        boolean refrence = false;
        AggregationBuilder lastAgg = null;
        block0: for (Field temp : this.select.getFields()) {
            if (!(temp instanceof MethodField) || !temp.getName().equals("script")) continue;
            MethodField scriptField = (MethodField)temp;
            for (KVValue kv : scriptField.getParams()) {
                if (!kv.value.equals(field.getName())) continue;
                lastAgg = this.aggMaker.makeGroupAgg(scriptField, this.select);
                refrence = true;
                continue block0;
            }
        }
        if (!refrence) {
            lastAgg = this.aggMaker.makeGroupAgg(field, this.select);
        }
        return lastAgg;
    }

    private AggregationBuilder wrapNestedIfNeeded(AggregationBuilder nestedBuilder, boolean reverseNested) {
        if (!reverseNested) {
            return nestedBuilder;
        }
        if (reverseNested && !(nestedBuilder instanceof NestedAggregationBuilder)) {
            return nestedBuilder;
        }
        return AggregationBuilders.reverseNested((String)(nestedBuilder.getName() + "_REVERSED")).subAggregation(nestedBuilder);
    }

    private AggregationBuilder createNestedAggregation(Field field) {
        String nestedPath = field.getNestedPath();
        if (field.isReverseNested()) {
            if (nestedPath == null || !nestedPath.startsWith("~")) {
                ReverseNestedAggregationBuilder reverseNestedAggregationBuilder = AggregationBuilders.reverseNested((String)this.getNestedAggName(field));
                if (nestedPath != null) {
                    reverseNestedAggregationBuilder.path(nestedPath);
                }
                return reverseNestedAggregationBuilder;
            }
            nestedPath = nestedPath.substring(1);
        }
        NestedAggregationBuilder nestedBuilder = AggregationBuilders.nested((String)this.getNestedAggName(field), (String)nestedPath);
        return nestedBuilder;
    }

    private AggregationBuilder createChildrenAggregation(Field field) {
        String childType = field.getChildType();
        ChildrenAggregationBuilder childrenBuilder = JoinAggregationBuilders.children((String)this.getChildrenAggName(field), (String)childType);
        return childrenBuilder;
    }

    private String getNestedAggName(Field field) {
        String nestedPath;
        String prefix = field instanceof MethodField ? ((nestedPath = field.getNestedPath()) != null ? nestedPath : field.getAlias()) : field.getName();
        return prefix + "@NESTED";
    }

    private String getChildrenAggName(Field field) {
        String childType;
        String prefix = field instanceof MethodField ? ((childType = field.getChildType()) != null ? childType : field.getAlias()) : field.getName();
        return prefix + "@CHILDREN";
    }

    private boolean insertFilterIfExistsAfter(AggregationBuilder agg, List<Field> groupBy, AggregationBuilder builder, int nextPosition) throws SqlParseException {
        if (groupBy.size() <= nextPosition) {
            return false;
        }
        Field filterFieldCandidate = groupBy.get(nextPosition);
        if (!(filterFieldCandidate instanceof MethodField)) {
            return false;
        }
        MethodField methodField = (MethodField)filterFieldCandidate;
        if (!methodField.getName().toLowerCase().equals("filter")) {
            return false;
        }
        builder.subAggregation(this.aggMaker.makeGroupAgg(filterFieldCandidate, this.select).subAggregation(agg));
        return true;
    }

    private AggregationBuilder updateAggIfNested(AggregationBuilder lastAgg, Field field) {
        if (field.isNested()) {
            lastAgg = AggregationBuilders.nested((String)(field.getName() + "Nested"), (String)field.getNestedPath()).subAggregation(lastAgg);
        }
        return lastAgg;
    }

    private boolean isASC(Order order) {
        return "ASC".equals(order.getType());
    }

    private void setFields(List<Field> fields) {
        if (this.select.getFields().size() > 0) {
            ArrayList<String> includeFields = new ArrayList<String>();
            for (Field field : fields) {
                if (field == null) continue;
                includeFields.add(field.getName());
            }
            this.request.setFetchSource(includeFields.toArray(new String[includeFields.size()]), null);
        }
    }

    private void explanFields(SearchRequestBuilder request, List<Field> fields, AggregationBuilder groupByAgg) throws SqlParseException {
        for (Field field : fields) {
            if (field instanceof MethodField) {
                if (field.getName().equals("script")) {
                    request.addStoredField(field.getAlias());
                    DefaultQueryAction defaultQueryAction = new DefaultQueryAction(this.client, this.select);
                    defaultQueryAction.intialize(request);
                    ArrayList tempFields = Lists.newArrayList((Object[])new Field[]{field});
                    defaultQueryAction.setFields(tempFields);
                    continue;
                }
                if (groupByAgg != null) {
                    if (field.getName().startsWith("rollingstd") || field.getName().startsWith("movingavg")) {
                        groupByAgg.subAggregation((PipelineAggregationBuilder)this.aggMaker.makeMovingFieldAgg((MethodField)field, groupByAgg));
                        continue;
                    }
                    groupByAgg.subAggregation(this.aggMaker.makeFieldAgg((MethodField)field, groupByAgg));
                    continue;
                }
                request.addAggregation(this.aggMaker.makeFieldAgg((MethodField)field, groupByAgg));
                continue;
            }
            if (field instanceof Field) {
                request.addStoredField(field.getName());
                continue;
            }
            throw new SqlParseException("it did not support this field method " + field);
        }
    }

    private void setWhere(Where where) throws SqlParseException {
        if (where != null) {
            BoolQueryBuilder whereQuery = QueryMaker.explan(where, this.select.isQuery);
            this.request.setQuery((QueryBuilder)whereQuery);
        }
    }

    private void setIndicesAndTypes() {
        this.request.setIndices(this.query.getIndexArr());
        String[] typeArr = this.query.getTypeArr();
        if (typeArr != null) {
            this.request.setTypes(typeArr);
        }
    }

    private void setLimitFromHint(List<Hint> hints) {
        int from = 0;
        int size = 0;
        for (Hint hint : hints) {
            if (hint.getType() != HintType.DOCS_WITH_AGGREGATION) continue;
            Integer[] params = (Integer[])hint.getParams();
            if (params.length > 1) {
                from = params[0];
                size = params[1];
                break;
            }
            if (params.length != 1) break;
            size = params[0];
            break;
        }
        this.request.setFrom(from);
        this.request.setSize(size);
    }

    private boolean isAliasFiled(String filedName) {
        if (this.select.getFields().size() > 0) {
            for (Field field : this.select.getFields()) {
                if (null == field.getAlias() || !field.getAlias().equals(filedName)) continue;
                return true;
            }
        }
        return false;
    }
}

