/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn.executors;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponseContentListener;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.plugin.nlpcn.ElasticHitsExecutor;
import org.elasticsearch.plugin.nlpcn.ElasticJoinExecutor;
import org.elasticsearch.plugin.nlpcn.ElasticUtils;
import org.elasticsearch.plugin.nlpcn.GetIndexRequestRestListener;
import org.elasticsearch.plugin.nlpcn.MetaSearchResult;
import org.elasticsearch.plugin.nlpcn.MultiRequestExecutorFactory;
import org.elasticsearch.plugin.nlpcn.executors.RestExecutor;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.search.SearchHits;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.SqlElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.JoinRequestBuilder;
import org.nlpcn.es4sql.query.multi.MultiQueryRequestBuilder;

public class ElasticDefaultRestExecutor
implements RestExecutor {
    @Override
    public void execute(Client client, Map<String, String> params, QueryAction queryAction, RestChannel channel) throws Exception {
        SqlElasticRequestBuilder requestBuilder = queryAction.explain();
        ActionRequest request = requestBuilder.request();
        if (requestBuilder instanceof JoinRequestBuilder) {
            ElasticJoinExecutor executor = ElasticJoinExecutor.createJoinExecutor(client, requestBuilder);
            executor.run();
            executor.sendResponse(channel);
        } else if (requestBuilder instanceof MultiQueryRequestBuilder) {
            ElasticHitsExecutor executor = MultiRequestExecutorFactory.createExecutor(client, (MultiQueryRequestBuilder)requestBuilder);
            executor.run();
            this.sendDefaultResponse(executor.getHits(), channel);
        } else if (request instanceof SearchRequest) {
            client.search((SearchRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
        } else if (request instanceof DeleteByQueryRequest) {
            requestBuilder.getBuilder().execute((ActionListener)new BulkIndexByScrollResponseContentListener(channel, (Map)Maps.newHashMap()));
        } else if (request instanceof GetIndexRequest) {
            requestBuilder.getBuilder().execute((ActionListener)new GetIndexRequestRestListener(channel, (GetIndexRequest)request));
        } else if (request instanceof SearchScrollRequest) {
            client.searchScroll((SearchScrollRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
        } else {
            throw new Exception(String.format("Unsupported ActionRequest provided: %s", request.getClass().getName()));
        }
    }

    @Override
    public String execute(Client client, Map<String, String> params, QueryAction queryAction) throws Exception {
        SqlElasticRequestBuilder requestBuilder = queryAction.explain();
        ActionRequest request = requestBuilder.request();
        if (requestBuilder instanceof JoinRequestBuilder) {
            ElasticJoinExecutor executor = ElasticJoinExecutor.createJoinExecutor(client, requestBuilder);
            executor.run();
            return BytesReference.bytes((XContentBuilder)ElasticUtils.hitsAsXContentBuilder(executor.getHits(), new MetaSearchResult())).utf8ToString();
        }
        if (requestBuilder instanceof MultiQueryRequestBuilder) {
            ElasticHitsExecutor executor = MultiRequestExecutorFactory.createExecutor(client, (MultiQueryRequestBuilder)requestBuilder);
            executor.run();
            return BytesReference.bytes((XContentBuilder)ElasticUtils.hitsAsXContentBuilder(executor.getHits(), new MetaSearchResult())).utf8ToString();
        }
        if (request instanceof SearchRequest) {
            ActionFuture future = client.search((SearchRequest)request);
            SearchResponse response = (SearchResponse)future.actionGet();
            return response.toString();
        }
        if (request instanceof DeleteByQueryRequest) {
            return requestBuilder.get().toString();
        }
        if (request instanceof GetIndexRequest) {
            return requestBuilder.getBuilder().execute().actionGet().toString();
        }
        throw new Exception(String.format("Unsupported ActionRequest provided: %s", request.getClass().getName()));
    }

    private void sendDefaultResponse(SearchHits hits, RestChannel channel) {
        try {
            XContentBuilder builder = ElasticUtils.hitsAsXContentBuilder(hits, new MetaSearchResult());
            BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, builder);
            channel.sendResponse((RestResponse)bytesRestResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

