/*
 * Decompiled with CFR 0.152.
 */
package ninja.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.websocket.server.ServerContainer;
import ninja.Bootstrap;
import ninja.servlet.NinjaServletBootstrap;
import ninja.utils.NinjaModeHelper;
import ninja.utils.NinjaPropertiesImpl;
import ninja.utils.SwissKnife;
import ninja.websockets.WebSockets;
import ninja.websockets.jsr356.Jsr356WebSockets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaServletListener
extends GuiceServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(NinjaServletListener.class);
    private volatile Bootstrap ninjaBootstrap;
    private NinjaPropertiesImpl ninjaProperties = null;
    private String contextPath;
    private Optional<Module> webSocketModule = Optional.empty();

    public synchronized void setNinjaProperties(NinjaPropertiesImpl ninjaPropertiesImpl) {
        if (this.ninjaProperties != null) {
            throw new IllegalStateException("NinjaProperties already set.");
        }
        this.ninjaProperties = ninjaPropertiesImpl;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.contextPath = servletContextEvent.getServletContext().getContextPath();
        if (SwissKnife.doesClassExist((String)"javax.websocket.server.ServerContainer", (Object)((Object)this))) {
            this.webSocketModule = WebsocketGuiceModuleCreator.getWebsocketServerContainerIfPossible(servletContextEvent.getServletContext());
        }
        super.contextInitialized(servletContextEvent);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.ninjaBootstrap.shutdown();
        super.contextDestroyed(servletContextEvent);
    }

    public Bootstrap getNinjaBootstrap() {
        return this.ninjaBootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getInjector() {
        Bootstrap ninjaBootstrapLocal = this.ninjaBootstrap;
        if (ninjaBootstrapLocal == null) {
            NinjaServletListener ninjaServletListener = this;
            synchronized (ninjaServletListener) {
                ninjaBootstrapLocal = this.ninjaBootstrap;
                if (ninjaBootstrapLocal == null) {
                    if (this.ninjaProperties == null) {
                        this.ninjaProperties = new NinjaPropertiesImpl(NinjaModeHelper.determineModeFromSystemPropertiesOrProdIfNotSet());
                    }
                    ninjaBootstrapLocal = this.ninjaBootstrap = this.createNinjaBootstrap(this.ninjaProperties, this.contextPath);
                }
            }
        }
        return ninjaBootstrapLocal.getInjector();
    }

    private Bootstrap createNinjaBootstrap(NinjaPropertiesImpl ninjaProperties, String contextPath) {
        ninjaProperties.setContextPath(contextPath);
        this.ninjaBootstrap = new NinjaServletBootstrap(ninjaProperties);
        this.webSocketModule.ifPresent(module -> this.ninjaBootstrap.addModule(module));
        this.ninjaBootstrap.boot();
        return this.ninjaBootstrap;
    }

    static class WebsocketGuiceModuleCreator {
        public static final String WEBSOCKET_SERVER_CONTAINER_CLASSNAME = "javax.websocket.server.ServerContainer";

        WebsocketGuiceModuleCreator() {
        }

        public static Optional<Module> getWebsocketServerContainerIfPossible(ServletContext servletContext) {
            final ServerContainer websocketServerContainer = (ServerContainer)servletContext.getAttribute(WEBSOCKET_SERVER_CONTAINER_CLASSNAME);
            logger.info("Using JSR-356 websocket container {}", (Object)websocketServerContainer);
            if (websocketServerContainer != null) {
                AbstractModule websocketsModule = new AbstractModule(){

                    protected void configure() {
                        this.bind(ServerContainer.class).toInstance((Object)websocketServerContainer);
                        this.bind(WebSockets.class).to(Jsr356WebSockets.class);
                    }
                };
                return Optional.of(websocketsModule);
            }
            return Optional.empty();
        }
    }
}

