/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.JSONTest;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import net.java.html.json.tests.WebSocketik;
import org.netbeans.html.json.tck.KOTest;

public final class WebSocketTest {
    private WebSocketik js;
    private String url;

    static void querySex(WebSocketik model, Person data) {
        if (data == null) {
            model.setOpen(1);
        } else {
            model.setFetched(data);
        }
    }

    @KOTest
    public void connectUsingWebSocket() throws Throwable {
        Person p;
        if (this.js == null) {
            this.url = Utils.prepareURL(JSONTest.class, "{'firstName': 'Mitar', 'sex': '$0' }", "application/javascript", "protocol:ws");
            this.js = (WebSocketik)Models.bind((Object)new WebSocketik(), (BrwsrCtx)WebSocketTest.newContext());
            this.js.applyBindings();
            this.js.setFetched(null);
            this.js.querySex(this.url, null);
        }
        if (this.bailOutIfNotSupported(this.js)) {
            return;
        }
        if (this.js.getOpen() == 0) {
            throw new InterruptedException();
        }
        if (this.js.getOpen() == 1) {
            this.js.querySex(this.url, Sex.FEMALE);
            this.js.setOpen(2);
        }
        if ((p = this.js.getFetched()) == null) {
            throw new InterruptedException();
        }
        assert ("Mitar".equals(p.getFirstName())) : "Unexpected: " + p.getFirstName();
        assert (Sex.FEMALE.equals((Object)p.getSex())) : "Expecting FEMALE: " + (Object)((Object)p.getSex());
        if (this.js.getOpen() == 2) {
            this.js.querySex(this.url, null);
            this.js.setOpen(3);
        }
        if (this.js.getFetchedResponse() == null) {
            throw new InterruptedException();
        }
        assert ("null".equals(this.js.getFetchedResponse())) : "Should be null: " + this.js.getFetchedResponse();
    }

    @KOTest
    public void errorUsingWebSocket() throws Throwable {
        if (this.js == null) {
            this.js = (WebSocketik)Models.bind((Object)new WebSocketik(), (BrwsrCtx)WebSocketTest.newContext());
            this.js.applyBindings();
            this.js.setFetched(null);
            this.js.querySex("http://wrong.protocol", null);
        }
        if (this.js.getFetchedResponse() == null) {
            throw new InterruptedException();
        }
        assert (this.js.getFetchedResponse() != null) : "Error reported";
    }

    @KOTest
    public void haveToOpenTheWebSocket() throws Throwable {
        block3: {
            this.js = (WebSocketik)Models.bind((Object)new WebSocketik(), (BrwsrCtx)WebSocketTest.newContext());
            this.js.applyBindings();
            this.js.setFetched(null);
            try {
                this.js.querySex("http://wrong.protocol", Sex.MALE);
                assert (false) : "Should throw an exception";
            }
            catch (IllegalStateException ex) {
                if ($assertionsDisabled || ex.getMessage().contains("not open")) break block3;
                throw new AssertionError((Object)("Expecting 'not open' msg: " + ex.getMessage()));
            }
        }
    }

    static void error(WebSocketik model, Exception ex) {
        if (ex != null) {
            model.setFetchedResponse(ex.getClass() + ":" + ex.getMessage());
        } else {
            model.setFetchedResponse("null");
        }
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(WebSocketTest.class);
    }

    private boolean bailOutIfNotSupported(WebSocketik js) {
        if (js.getFetchedResponse() == null) {
            return false;
        }
        return js.getFetchedResponse().contains("UnsupportedOperationException") && Utils.canFailWebSockets(WebSocketTest.class);
    }
}

