/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Rmrel
extends TransactionProvidingApp {
    public Rmrel() {
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.NONE, "Force deletion, i.e. disables the connectedness check"));
        this.addOptionDefinition("d", new OptionDefinition(OptionValueType.NONE, "Also delete the node on the other side of the relationship if removing this relationship results in it not having any relationships left"));
    }

    @Override
    public String getDescription() {
        return "Deletes a relationship, also ensuring the connectedness of the graph. That check can be ignored with -f\nUsage: rmrel <relationship id>\n   or  rmrel -f <relationship id>";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        this.assertCurrentIsNode(session);
        if (parser.arguments().isEmpty()) {
            throw new ShellException("Must supply relationship id to delete as the first argument");
        }
        Node currentNode = this.getCurrent(session).asNode();
        Relationship rel = this.findRel(currentNode, Long.parseLong(parser.arguments().get(0)));
        rel.delete();
        Node otherNode = rel.getOtherNode(currentNode);
        boolean deleteOtherNodeIfEmpty = parser.options().containsKey("d");
        if (deleteOtherNodeIfEmpty && !otherNode.hasRelationship()) {
            out.println((Serializable)((Object)("Also deleted " + Rmrel.getDisplayName(this.getServer(), session, otherNode, false) + " due to it not having any relationships left")));
            otherNode.delete();
        }
        return Continuation.INPUT_COMPLETE;
    }

    private Relationship findRel(Node currentNode, long relId) throws ShellException {
        Relationship rel = this.getServer().getDb().getRelationshipById(relId);
        if (rel.getStartNode().equals(currentNode) || rel.getEndNode().equals(currentNode)) {
            return rel;
        }
        throw new ShellException("No relationship " + relId + " connected to " + currentNode);
    }
}

