/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.neo4j.shell.Output;
import org.neo4j.shell.impl.RemoteOutput;

public class SystemOutput
implements Output {
    private PrintWriter out;

    public SystemOutput() {
        this(System.out);
    }

    public SystemOutput(OutputStream out) {
        this.out = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    @Override
    public void print(Serializable object) {
        this.out.print(object);
    }

    @Override
    public void println() {
        this.out.println();
        this.out.flush();
    }

    @Override
    public void println(Serializable object) {
        this.out.println(object);
        this.out.flush();
    }

    @Override
    public Appendable append(char ch) {
        this.print(Character.valueOf(ch));
        return this;
    }

    @Override
    public Appendable append(CharSequence sequence) {
        this.println((Serializable)((Object)RemoteOutput.asString(sequence)));
        return this;
    }

    @Override
    public Appendable append(CharSequence sequence, int start, int end) {
        this.print((Serializable)((Object)RemoteOutput.asString(sequence).substring(start, end)));
        return this;
    }
}

