/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.neo4j.upgrade.loader.EmbeddedJarNotFoundException;

public class EmbeddedJarLoader
implements AutoCloseable {
    private String[] jars;
    private Collection<File> extractedFiles = new ArrayList<File>();
    private URLClassLoader jarsClassLoader;

    EmbeddedJarLoader(String ... jars) {
        this.jars = jars;
    }

    public Class loadEmbeddedClass(String className) throws ClassNotFoundException, IOException {
        return this.getJarsClassLoader().loadClass(className);
    }

    public ClassLoader getJarsClassLoader() throws IOException {
        if (this.jarsClassLoader == null) {
            this.jarsClassLoader = this.buildJarClassLoader();
        }
        return this.jarsClassLoader;
    }

    @Override
    public void close() throws IOException {
        if (this.jarsClassLoader != null) {
            this.jarsClassLoader.close();
        }
        this.extractedFiles.forEach(File::delete);
        this.extractedFiles.clear();
    }

    private URLClassLoader buildJarClassLoader() throws IOException {
        Collection<File> jarFiles = this.getJars();
        URL[] urls = (URL[])jarFiles.stream().map(EmbeddedJarLoader::getFileURL).toArray(URL[]::new);
        return new URLClassLoader(urls, null);
    }

    private Collection<File> getJars() throws IOException {
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (String jar : this.jars) {
            URL url = this.getClass().getClassLoader().getResource(jar);
            if (url == null) {
                jarFiles.add(this.loadJarFromRelativePath(jar));
                continue;
            }
            File extractedFile = this.extractJar(url, jar);
            jarFiles.add(extractedFile);
            this.extractedFiles.add(extractedFile);
        }
        return jarFiles;
    }

    private File extractJar(URL resourceUrl, String jar) throws IOException {
        URLConnection connection = resourceUrl.openConnection();
        if (connection instanceof JarURLConnection) {
            JarURLConnection urlConnection = (JarURLConnection)connection;
            JarFile jarFile = urlConnection.getJarFile();
            JarEntry jarEntry = urlConnection.getJarEntry();
            if (jarEntry == null) {
                throw new EmbeddedJarNotFoundException("Jar file '" + jar + "' not found.");
            }
            return this.extract(jarFile, jarEntry);
        }
        throw new EmbeddedJarNotFoundException("Jar file '" + jar + "' not found.");
    }

    private File loadJarFromRelativePath(String jar) {
        try {
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            URI uri = codeSource.getLocation().toURI();
            File jarFile = new File(new File(uri).getParent(), jar);
            if (!jarFile.exists()) {
                throw new EmbeddedJarNotFoundException("Jar file '" + jar + "' not found.");
            }
            return jarFile;
        }
        catch (URISyntaxException e) {
            throw new EmbeddedJarNotFoundException("Jar file '" + jar + "' not found.");
        }
    }

    private File extract(JarFile jarFile, JarEntry jarEntry) throws IOException {
        File extractedFile = this.createTempFile(jarEntry);
        try (InputStream jarInputStream = jarFile.getInputStream(jarEntry);){
            Files.copy(jarInputStream, extractedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return extractedFile;
    }

    private File createTempFile(JarEntry jarEntry) throws IOException {
        File tempFile = File.createTempFile(jarEntry.getName(), "jar");
        tempFile.deleteOnExit();
        return tempFile;
    }

    private static URL getFileURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Can't convert file " + file + " URI into URL.", e);
        }
    }
}

