/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndex;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.NodePropertyUpdate;

public abstract class LuceneIndexPopulator
implements IndexPopulator {
    protected LuceneSchemaIndex luceneIndex;
    protected LuceneIndexWriter writer;

    LuceneIndexPopulator(LuceneSchemaIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    public void create() throws IOException {
        this.luceneIndex.create();
        this.luceneIndex.open();
        this.writer = this.luceneIndex.getIndexWriter();
    }

    public void drop() throws IOException {
        this.luceneIndex.drop();
    }

    public void add(Collection<NodePropertyUpdate> updates) throws IndexEntryConflictException, IOException {
        Iterator documents = updates.stream().map(LuceneIndexPopulator::updateAsDocument).iterator();
        this.writer.addDocuments(() -> documents);
    }

    public void close(boolean populationCompletedSuccessfully) throws IOException {
        try {
            if (populationCompletedSuccessfully) {
                this.luceneIndex.markAsOnline();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new LuceneSchemaIndex[]{this.luceneIndex});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new LuceneSchemaIndex[]{this.luceneIndex});
    }

    public void markAsFailed(String failure) throws IOException {
        this.luceneIndex.markAsFailed(failure);
    }

    private static Document updateAsDocument(NodePropertyUpdate update) {
        return LuceneDocumentStructure.documentRepresentingProperty(update.getNodeId(), update.getValueAfter());
    }
}

