/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.File;
import java.util.function.Supplier;
import org.neo4j.kernel.api.impl.index.LuceneKernelExtensions;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndexBuilder;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;

public class LuceneLabelScanStoreExtension
extends KernelExtensionFactory<Dependencies> {
    private final int priority;
    private final LuceneLabelScanStore.Monitor monitor;

    public LuceneLabelScanStoreExtension() {
        this(10, null);
    }

    LuceneLabelScanStoreExtension(int priority, LuceneLabelScanStore.Monitor monitor) {
        super("lucene-scan-store");
        this.priority = priority;
        this.monitor = monitor == null ? LuceneLabelScanStore.Monitor.EMPTY : monitor;
    }

    public LabelScanStoreProvider newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        boolean ephemeral = (Boolean)dependencies.getConfig().get(GraphDatabaseFacadeFactory.Configuration.ephemeral);
        DirectoryFactory directoryFactory = LuceneKernelExtensions.directoryFactory(ephemeral, context.fileSystem());
        LuceneLabelScanIndex index = this.getLuceneIndex(context, directoryFactory);
        LuceneLabelScanStore scanStore = new LuceneLabelScanStore(index, LabelScanStoreProvider.fullStoreLabelUpdateStream(dependencies.indexStoreView()), dependencies.getLogService().getInternalLogProvider(), this.monitor);
        return new LabelScanStoreProvider((LabelScanStore)scanStore, this.priority);
    }

    private LuceneLabelScanIndex getLuceneIndex(KernelContext context, DirectoryFactory directoryFactory) {
        return ((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)LuceneLabelScanIndexBuilder.create().withDirectoryFactory(directoryFactory)).withFileSystem(context.fileSystem())).withIndexRootFolder(LabelScanStoreProvider.getStoreDirectory((File)context.storeDir()))).build();
    }

    public static interface Dependencies {
        public Config getConfig();

        public Supplier<IndexStoreView> indexStoreView();

        public LogService getLogService();
    }
}

