/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.IndexType;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.LuceneLegacyIndex;
import org.neo4j.index.impl.lucene.legacy.LuceneTransactionState;
import org.neo4j.kernel.api.LegacyIndex;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.spi.legacyindex.IndexCommandFactory;
import org.neo4j.kernel.spi.legacyindex.LegacyIndexProviderTransaction;

public class LuceneLegacyIndexTransaction
implements LegacyIndexProviderTransaction {
    private final LuceneDataSource dataSource;
    private final Map<String, LuceneLegacyIndex> nodeIndexes = new HashMap<String, LuceneLegacyIndex>();
    private final Map<String, LuceneLegacyIndex> relationshipIndexes = new HashMap<String, LuceneLegacyIndex>();
    private final LuceneTransactionState luceneTransaction;
    private final IndexCommandFactory commandFactory;

    public LuceneLegacyIndexTransaction(LuceneDataSource dataSource, IndexCommandFactory commandFactory) {
        this.dataSource = dataSource;
        this.commandFactory = commandFactory;
        this.luceneTransaction = new LuceneTransactionState();
    }

    public LegacyIndex nodeIndex(String indexName, Map<String, String> configuration) {
        LuceneLegacyIndex index = this.nodeIndexes.get(indexName);
        if (index == null) {
            IndexIdentifier identifier = new IndexIdentifier(IndexEntityType.Node, indexName);
            index = new LuceneLegacyIndex.NodeLegacyIndex(this.dataSource, identifier, this.luceneTransaction, IndexType.getIndexType(configuration), this.commandFactory);
            this.nodeIndexes.put(indexName, index);
        }
        return index;
    }

    public LegacyIndex relationshipIndex(String indexName, Map<String, String> configuration) {
        LuceneLegacyIndex index = this.relationshipIndexes.get(indexName);
        if (index == null) {
            IndexIdentifier identifier = new IndexIdentifier(IndexEntityType.Relationship, indexName);
            index = new LuceneLegacyIndex.RelationshipLegacyIndex(this.dataSource, identifier, this.luceneTransaction, IndexType.getIndexType(configuration), this.commandFactory);
            this.relationshipIndexes.put(indexName, index);
        }
        return index;
    }

    public void close() {
        this.luceneTransaction.close();
    }
}

