/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.NoSuchElementException;
import org.neo4j.collection.primitive.PrimitiveLongCollection;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;

public class PrimitiveLongArrayQueue
implements PrimitiveLongCollection {
    private static final int DEFAULT_CAPACITY = 16;
    private long[] values;
    private int head;
    private int tail;

    public PrimitiveLongArrayQueue() {
        this(16);
    }

    PrimitiveLongArrayQueue(int capacity) {
        assert (capacity != 0 && (capacity & capacity - 1) == 0) : "Capacity should be power of 2.";
        this.initValues(capacity);
    }

    @Override
    public <E extends Exception> void visitKeys(PrimitiveLongVisitor<E> visitor) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public void clear() {
        this.initValues(16);
    }

    @Override
    public int size() {
        return this.tail - this.head & this.values.length - 1;
    }

    @Override
    public void close() {
        this.values = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
    }

    @Override
    public PrimitiveLongIterator iterator() {
        return new PrimitiveLongArrayQueueIterator();
    }

    public long dequeue() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Fail to poll first element. Queue is empty.");
        }
        long value = this.values[this.head];
        this.head = this.head + 1 & this.values.length - 1;
        return value;
    }

    public void enqueue(long value) {
        this.values[this.tail] = value;
        this.tail = this.tail + 1 & this.values.length - 1;
        if (this.tail == this.head) {
            this.ensureCapacity();
        }
    }

    public void addAll(PrimitiveLongArrayQueue otherQueue) {
        while (!otherQueue.isEmpty()) {
            this.enqueue(otherQueue.dequeue());
        }
    }

    private void initValues(int capacity) {
        this.values = new long[capacity];
        this.head = 0;
        this.tail = 0;
    }

    private void ensureCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Fail to increase queue capacity.");
        }
        long[] newValues = new long[newCapacity];
        int elementsFromHeadTillEnd = this.values.length - this.head;
        System.arraycopy(this.values, this.head, newValues, 0, elementsFromHeadTillEnd);
        System.arraycopy(this.values, 0, newValues, elementsFromHeadTillEnd, this.head);
        this.tail = this.values.length;
        this.head = 0;
        this.values = newValues;
    }

    private class PrimitiveLongArrayQueueIterator
    implements PrimitiveLongIterator {
        private int position;

        PrimitiveLongArrayQueueIterator() {
            this.position = PrimitiveLongArrayQueue.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.position != PrimitiveLongArrayQueue.this.tail;
        }

        @Override
        public long next() {
            if (this.hasNext()) {
                long value = PrimitiveLongArrayQueue.this.values[this.position];
                this.position = this.position + 1 & PrimitiveLongArrayQueue.this.values.length - 1;
                return value;
            }
            throw new NoSuchElementException();
        }
    }
}

