/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.test.CleanupRule;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.MultiExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class MultiExecutionMonitorTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Test
    public void shouldCheckMultipleMonitors() throws Exception {
        FakeClock clock = new FakeClock();
        TestableMonitor first = new TestableMonitor(clock, 100L, TimeUnit.MILLISECONDS, "first");
        TestableMonitor other = new TestableMonitor(clock, 250L, TimeUnit.MILLISECONDS, "other");
        MultiExecutionMonitor multiMonitor = new MultiExecutionMonitor((Clock)clock, new ExecutionMonitor[]{first, other});
        clock.forward(110L, TimeUnit.MILLISECONDS);
        this.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 1, other, 0});
        clock.forward(100L, TimeUnit.MILLISECONDS);
        this.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 2, other, 0});
        clock.forward(45L, TimeUnit.MILLISECONDS);
        this.expectCallsToCheck((ExecutionMonitor)multiMonitor, new Object[]{first, 2, other, 1});
    }

    private void expectCallsToCheck(ExecutionMonitor multiMonitor, Object ... alternatingMonitorAndCount) {
        multiMonitor.check(null);
        for (int i = 0; i < alternatingMonitorAndCount.length; ++i) {
            TestableMonitor monitor = (TestableMonitor)((Object)alternatingMonitorAndCount[i++]);
            int count = (Integer)alternatingMonitorAndCount[i];
            Assert.assertThat((Object)monitor.timesPolled, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(count)));
            if (monitor.timesPolled >= count) continue;
            Assert.fail((String)("Polls didn't occur, expected " + Arrays.toString(alternatingMonitorAndCount)));
        }
    }

    private static class TestableMonitor
    extends ExecutionMonitor.Adapter {
        private int timesPolled;
        private final String name;

        public TestableMonitor(Clock clock, long interval, TimeUnit unit, String name) {
            super(clock, interval, unit);
            this.name = name;
        }

        public void check(StageExecution[] executions) {
            ++this.timesPolled;
        }

        public String toString() {
            return "[" + this.name + ":" + this.timesPolled + "]";
        }
    }
}

