/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.UpdateBehaviour;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.ExternalPropertiesDecorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;

public class ExternalPropertiesDecoratorIT {
    @Test
    public void shouldDecorateExternalPropertiesInParallelProcessingCsvInput() throws Exception {
        int processors = 5;
        Collector collector = (Collector)Mockito.mock(Collector.class);
        int count = 1000;
        Configuration.Overridden config = new Configuration.Overridden(Configuration.COMMAS){

            public int bufferSize() {
                return 300;
            }
        };
        IdType idType = IdType.STRING;
        ExternalPropertiesDecorator decorator = new ExternalPropertiesDecorator(DataFactories.data((Decorator)InputEntityDecorators.NO_NODE_DECORATOR, () -> this.decoratedData(count)), DataFactories.defaultFormatNodeFileHeader(), (Configuration)config, idType, UpdateBehaviour.ADD, collector);
        CsvInput input = new CsvInput(DataFactories.nodeData((DataFactory[])new DataFactory[]{DataFactories.data((Decorator)decorator, () -> this.mainData(count))}), DataFactories.defaultFormatNodeFileHeader(), null, null, idType, (Configuration)config, collector, processors);
        try (InputIterator nodes = input.nodes().iterator();){
            int i;
            for (i = 0; i < count; ++i) {
                Assert.assertTrue((boolean)nodes.hasNext());
                InputNode node = (InputNode)nodes.next();
                this.assertHasProperty(node, "extra", node.id() + "-decorated");
                if (i != 0) continue;
                nodes.processors(processors - nodes.processors(0));
            }
            Assert.assertEquals((long)count, (long)i);
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    private void assertHasProperty(InputNode node, String key, Object value) {
        Object[] properties = node.properties();
        boolean found = false;
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i++].toString().equals(key)) continue;
            Assert.assertFalse((boolean)found);
            found = true;
            Assert.assertEquals((Object)value, (Object)properties[i]);
        }
        Assert.assertTrue((boolean)found);
    }

    String id(int i) {
        return String.valueOf(i);
    }

    private CharReadable decoratedData(int count) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream printer = new PrintStream(out);){
            printer.println(":ID,extra");
            for (int i = 0; i < count; ++i) {
                printer.println(this.id(i) + "," + this.id(i) + "-decorated");
            }
        }
        return Readables.wrap((Reader)new StringReader(out.toString()));
    }

    private CharReadable mainData(int count) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream printer = new PrintStream(out);){
            printer.println(":ID");
            for (int i = 0; i < count; ++i) {
                printer.println(this.id(i));
            }
        }
        return Readables.wrap((Reader)new StringReader(out.toString()));
    }
}

