/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.Factory;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.test.RandomRule;
import org.neo4j.test.RepeatRule;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.ControlledEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.IntTracker;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongTracker;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Tracker;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.TrackerFactory;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.SimpleInputIterator;
import org.neo4j.unsafe.impl.batchimport.input.SimpleInputIteratorWrapper;

@RunWith(value=Parameterized.class)
public class EncodingIdMapperTest {
    private final int processors;
    private static final TrackerFactory RANDOM_TRACKER_FACTORY = new TrackerFactory(){

        public Tracker create(NumberArrayFactory arrayFactory, long size) {
            return System.currentTimeMillis() % 2L == 0L ? new IntTracker(arrayFactory.newIntArray(size, -1)) : new LongTracker(arrayFactory.newLongArray(size, -1L));
        }
    };
    @Rule
    public final RandomRule random = new RandomRule().withSeed(1436724681847L);
    @Rule
    public final RepeatRule repeater = new RepeatRule();

    @Parameterized.Parameters(name="processors:{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{1});
        data.add(new Object[]{2});
        int bySystem = Runtime.getRuntime().availableProcessors() - 1;
        if (bySystem > 2) {
            data.add(new Object[]{bySystem});
        }
        return data;
    }

    public EncodingIdMapperTest(int processors) {
        this.processors = processors;
    }

    @Test
    public void shouldHandleGreatAmountsOfStuff() throws Exception {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        InputIterable<Object> ids = new InputIterable<Object>(){

            public InputIterator<Object> iterator() {
                return new InputIterator.Adapter<Object>(){
                    private int i;

                    protected Object fetchNextOrNull() {
                        return this.i < 300000 ? "" + this.i++ : null;
                    }
                };
            }

            public boolean supportsMultiplePasses() {
                return false;
            }
        };
        long index = 0L;
        for (Object id : ids) {
            idMapper.put(id, index++, Group.GLOBAL);
        }
        idMapper.prepare((InputIterable)ids, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (Object id : ids) {
            if (idMapper.get(id, Group.GLOBAL) != -1L) continue;
            Assert.fail((String)("Couldn't find " + id + " even though I added it just previously"));
        }
    }

    @Test
    public void shouldReturnExpectedValueForNotFound() throws Exception {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        idMapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        long id = idMapper.get((Object)"123", Group.GLOBAL);
        Assert.assertEquals((long)-1L, (long)id);
    }

    @Test
    public void shouldReportyProgressForSortAndDetect() throws Exception {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        ProgressListener progress = (ProgressListener)Mockito.mock(ProgressListener.class);
        idMapper.prepare(null, (Collector)Mockito.mock(Collector.class), progress);
        long id = idMapper.get((Object)"123", Group.GLOBAL);
        Assert.assertEquals((long)-1L, (long)id);
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)3))).started(Matchers.anyString());
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)3))).done();
    }

    @Test
    public void shouldEncodeShortStrings() throws Exception {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        mapper.put((Object)"123", 0L, Group.GLOBAL);
        mapper.put((Object)"456", 1L, Group.GLOBAL);
        mapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"456", Group.GLOBAL));
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"123", Group.GLOBAL));
    }

    @Test
    public void shouldEncodeSmallSetOfRandomData() throws Throwable {
        Object value;
        int size = this.random.nextInt(10000) + 2;
        ValueType type = ValueType.values()[this.random.nextInt(ValueType.values().length)];
        IdMapper mapper = this.mapper(type.encoder(), type.radix(), EncodingIdMapper.NO_MONITOR);
        ValueGenerator values = new ValueGenerator(size, type.data(this.random.random()));
        int id = 0;
        InputIterator inputIterator = values.iterator();
        while (inputIterator.hasNext()) {
            value = inputIterator.next();
            mapper.put(value, (long)id++, Group.GLOBAL);
        }
        mapper.prepare((InputIterable)values, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        id = 0;
        inputIterator = values.iterator();
        while (inputIterator.hasNext()) {
            value = inputIterator.next();
            Assert.assertEquals((String)("Expected " + value + " to map to " + id), (long)id++, (long)mapper.get(value, Group.GLOBAL));
        }
    }

    @Test
    public void shouldReportCollisionsForSameInputId() throws Exception {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        InputIterable<Object> ids = SimpleInputIteratorWrapper.wrap("source", Arrays.asList("10", "9", "10"));
        try (InputIterator iterator = ids.iterator();){
            int i = 0;
            while (iterator.hasNext()) {
                mapper.put(iterator.next(), (long)i, Group.GLOBAL);
                ++i;
            }
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, ProgressListener.NONE);
        ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectDuplicateNode((Object)"10", 2L, Group.GLOBAL.name(), "source:1", "source:3");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
    }

    @Test
    public void shouldIncludeSourceLocationsOfCollisions() throws Exception {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        List<Object> idList = Arrays.asList("10", "9", "10");
        InputIterable<Object> ids = SimpleInputIteratorWrapper.wrap("source", idList);
        Group.Adapter group = new Group.Adapter(Group.GLOBAL.id(), "global");
        try (InputIterator iterator = ids.iterator();){
            int i = 0;
            while (iterator.hasNext()) {
                mapper.put(iterator.next(), (long)i, (Group)group);
                ++i;
            }
        }
        try {
            mapper.prepare(ids, Collectors.badCollector((OutputStream)new ByteArrayOutputStream(), (int)0), ProgressListener.NONE);
            Assert.fail((String)"Should have failed");
        }
        catch (DuplicateInputIdException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.containsString((String)"10"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.containsString((String)"source:1"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.containsString((String)"source:3"));
        }
    }

    @Test
    public void shouldCopeWithCollisionsBasedOnDifferentInputIds() throws Exception {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        Encoder encoder = (Encoder)Mockito.mock(Encoder.class);
        Mockito.when((Object)encoder.encode(Matchers.any())).thenReturn((Object)12345L);
        IdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.STRING, monitor);
        InputIterable<Object> ids = SimpleInputIteratorWrapper.wrap("source", Arrays.asList("10", "9"));
        try (InputIterator iterator = ids.iterator();){
            int i = 0;
            while (iterator.hasNext()) {
                mapper.put(iterator.next(), (long)i, Group.GLOBAL);
                ++i;
            }
        }
        ProgressListener progress = (ProgressListener)Mockito.mock(ProgressListener.class);
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, progress);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(2);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"10", Group.GLOBAL));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"9", Group.GLOBAL));
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)7))).started(Matchers.anyString());
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)7))).done();
    }

    @Test
    public void shouldCopeWithMixedActualAndAccidentalCollisions() throws Exception {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        Encoder encoder = (Encoder)Mockito.mock(Encoder.class);
        String a = new String("a");
        String b = new String("b");
        String c = new String("c");
        String a2 = new String("a");
        String e = new String("e");
        String f = new String("f");
        Mockito.when((Object)encoder.encode((Object)a)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)b)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)c)).thenReturn((Object)3L);
        Mockito.when((Object)encoder.encode((Object)a2)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)e)).thenReturn((Object)2L);
        Mockito.when((Object)encoder.encode((Object)f)).thenReturn((Object)1L);
        IdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.STRING, monitor);
        InputIterable<Object> ids = SimpleInputIteratorWrapper.wrap("source", Arrays.asList("a", "b", "c", "a", "e", "f"));
        Group.Adapter groupA = new Group.Adapter(1, "A");
        Group.Adapter groupB = new Group.Adapter(2, "B");
        Group[] groups = new Group[]{groupA, groupA, groupA, groupB, groupB, groupB};
        try (InputIterator iterator = ids.iterator();){
            int i = 0;
            while (iterator.hasNext()) {
                mapper.put(iterator.next(), (long)i, groups[i]);
                ++i;
            }
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, (ProgressListener)Mockito.mock(ProgressListener.class));
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(4);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)a, (Group)groupA));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)b, (Group)groupA));
        Assert.assertEquals((long)2L, (long)mapper.get((Object)c, (Group)groupA));
        Assert.assertEquals((long)3L, (long)mapper.get((Object)a2, (Group)groupB));
        Assert.assertEquals((long)4L, (long)mapper.get((Object)e, (Group)groupB));
        Assert.assertEquals((long)5L, (long)mapper.get((Object)f, (Group)groupB));
    }

    @Test
    public void shouldBeAbleToHaveDuplicateInputIdButInDifferentGroups() throws Exception {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, monitor);
        InputIterable<Object> ids = SimpleInputIteratorWrapper.wrap("source", Arrays.asList("10", "9", "10"));
        Groups groups = new Groups();
        Group firstGroup = groups.getOrCreate("first");
        Group secondGroup = groups.getOrCreate("second");
        try (InputIterator iterator = ids.iterator();){
            int id = 0;
            mapper.put(iterator.next(), (long)id++, firstGroup);
            mapper.put(iterator.next(), (long)id++, firstGroup);
            mapper.put(iterator.next(), (long)id++, secondGroup);
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, ProgressListener.NONE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(0);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"10", firstGroup));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"9", firstGroup));
        Assert.assertEquals((long)2L, (long)mapper.get((Object)"10", secondGroup));
    }

    @Test
    public void shouldOnlyFindInputIdsInSpecificGroup() throws Exception {
        Group thirdGroup;
        Group secondGroup;
        Group firstGroup;
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        InputIterable<Object> ids = SimpleInputIteratorWrapper.wrap("source", Arrays.asList("8", "9", "10"));
        Groups groups = new Groups();
        try (InputIterator iterator = ids.iterator();){
            int id = 0;
            int n = id++;
            firstGroup = groups.getOrCreate("first");
            mapper.put(iterator.next(), (long)n, firstGroup);
            int n2 = id++;
            secondGroup = groups.getOrCreate("second");
            mapper.put(iterator.next(), (long)n2, secondGroup);
            int n3 = id++;
            thirdGroup = groups.getOrCreate("third");
            mapper.put(iterator.next(), (long)n3, thirdGroup);
        }
        mapper.prepare(ids, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"8", firstGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"8", secondGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"8", thirdGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"9", firstGroup));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"9", secondGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"9", thirdGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"10", firstGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"10", secondGroup));
        Assert.assertEquals((long)2L, (long)mapper.get((Object)"10", thirdGroup));
    }

    @Test
    public void shouldHandleManyGroups() throws Exception {
        int i;
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR);
        int size = 100;
        for (i = 0; i < size; ++i) {
            mapper.put((Object)i, (long)i, (Group)new Group.Adapter(i, "" + i));
        }
        mapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)i, (long)mapper.get((Object)i, (Group)new Group.Adapter(i, "" + i)));
        }
    }

    @Test
    public void shouldDetectCorrectDuplicateInputIdsWhereManyAccidentalInManyGroups() throws Exception {
        final ControlledEncoder encoder = new ControlledEncoder((Encoder)new LongEncoder());
        IdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR);
        int idsPerGroup = 20;
        int groups = 5;
        final AtomicReference group = new AtomicReference();
        InputIterable<Object> ids = SimpleInputIteratorWrapper.wrap("source", new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new PrefetchingIterator<Object>(){
                    private int i;

                    protected Object fetchNextOrNull() {
                        if (this.i % 20 == 0) {
                            int groupId = this.i / 20;
                            if (groupId == 5) {
                                return null;
                            }
                            group.set(new Group.Adapter(groupId, "Group " + groupId));
                        }
                        try {
                            if (this.i % 20 < 2) {
                                encoder.useThisIdToEncodeNoMatterWhatComesIn(1234567L);
                                Long l = this.i % 20;
                                return l;
                            }
                            encoder.useThisIdToEncodeNoMatterWhatComesIn(123456 - ((Group)group.get()).id());
                            Long l = this.i;
                            return l;
                        }
                        finally {
                            ++this.i;
                        }
                    }
                };
            }
        });
        long actualId = 0L;
        for (Object id : ids) {
            mapper.put(id, actualId++, (Group)group.get());
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, ProgressListener.NONE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        actualId = 0L;
        for (Object id : ids) {
            Assert.assertEquals((long)actualId++, (long)mapper.get(id, (Group)group.get()));
        }
    }

    @Test
    public void shouldHandleHolesInIdSequence() throws Exception {
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < 100; ++i) {
            if (this.random.nextBoolean()) continue;
            Long id = i;
            ids.add(id);
            mapper.put((Object)id, (long)i, Group.GLOBAL);
        }
        mapper.prepare(SimpleInputIteratorWrapper.wrap("source", ids), (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (Long id : ids) {
            Assert.assertEquals((long)id, (long)mapper.get((Object)id, Group.GLOBAL));
        }
    }

    @Test
    public void shouldHandleLargeAmountsOfDuplicateNodeIds() throws Exception {
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR);
        long nodeId = 0L;
        int high = 10;
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int run = 0; run < 2; ++run) {
            for (long i = 0L; i < (long)(high / 2); ++i) {
                ids.add((long)high - (i + 1L));
                ids.add(i);
            }
        }
        for (Object e : ids) {
            mapper.put(e, nodeId++, Group.GLOBAL);
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(SimpleInputIteratorWrapper.wrap("source", ids), collector, ProgressListener.NONE);
        ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)high))).collectDuplicateNode(Matchers.any(Object.class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    private IdMapper mapper(Encoder encoder, Factory<Radix> radix, EncodingIdMapper.Monitor monitor) {
        return this.mapper(encoder, radix, monitor, ParallelSort.DEFAULT);
    }

    private IdMapper mapper(Encoder encoder, Factory<Radix> radix, EncodingIdMapper.Monitor monitor, ParallelSort.Comparator comparator) {
        return new EncodingIdMapper(NumberArrayFactory.HEAP, encoder, radix, monitor, RANDOM_TRACKER_FACTORY, 1000, this.processors, comparator);
    }

    private static enum ValueType {
        LONGS{

            @Override
            Encoder encoder() {
                return new LongEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.LONG;
            }

            @Override
            Factory<Object> data(final Random random) {
                return new Factory<Object>(){

                    public Object newInstance() {
                        return random.nextInt(1000000000);
                    }
                };
            }
        }
        ,
        LONGS_AS_STRINGS{

            @Override
            Encoder encoder() {
                return new StringEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.STRING;
            }

            @Override
            Factory<Object> data(final Random random) {
                return new Factory<Object>(){

                    public Object newInstance() {
                        return String.valueOf(random.nextInt(1000000000));
                    }
                };
            }
        }
        ,
        VERY_LONG_STRINGS{
            char[] CHARS = "\u00bd!\"#\u00a4%&/()=?`\u00b4;:,._-<>".toCharArray();

            @Override
            Encoder encoder() {
                return new StringEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.STRING;
            }

            @Override
            Factory<Object> data(final Random random) {
                return new Factory<Object>(){

                    public Object newInstance() {
                        int length = 1500;
                        for (int i = 0; i < 4; ++i) {
                            length = random.nextInt(length) + 20;
                        }
                        char[] chars = new char[length];
                        for (int i = 0; i < length; ++i) {
                            char ch = random.nextBoolean() ? this.randomLetter(random) : CHARS[random.nextInt(CHARS.length)];
                            chars[i] = ch;
                        }
                        return new String(chars);
                    }

                    private char randomLetter(Random random2) {
                        int base = random2.nextBoolean() ? 97 : 65;
                        int size = 25;
                        return (char)(base + random2.nextInt(size));
                    }
                };
            }
        };


        abstract Encoder encoder();

        abstract Factory<Radix> radix();

        abstract Factory<Object> data(Random var1);
    }

    private class ValueGenerator
    implements InputIterable<Object> {
        private final int size;
        private final Factory<Object> generator;
        private final List<Object> values = new ArrayList<Object>();
        private final Set<Object> deduper = new HashSet<Object>();

        ValueGenerator(int size, Factory<Object> generator) {
            this.size = size;
            this.generator = generator;
        }

        public InputIterator<Object> iterator() {
            if (!this.values.isEmpty()) {
                return new SimpleInputIteratorWrapper<Object>(this.getClass().getSimpleName(), this.values.iterator());
            }
            return new SimpleInputIterator<Object>(""){
                private int cursor;

                protected Object fetchNextOrNull() {
                    if (this.cursor < ValueGenerator.this.size) {
                        Object value;
                        do {
                            value = ValueGenerator.this.generator.newInstance();
                        } while (!ValueGenerator.this.deduper.add(value));
                        ValueGenerator.this.values.add(value);
                        ++this.cursor;
                        return value;
                    }
                    return null;
                }
            };
        }

        public boolean supportsMultiplePasses() {
            return false;
        }
    }
}

