/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.test.RandomRule;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class RelationshipGroupCacheTest {
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldPutGroupsOnlyWithinPreparedRange() throws Exception {
        int nodeCount = 1000;
        RelationshipGroupCache cache = new RelationshipGroupCache(NumberArrayFactory.HEAP, ByteUnit.kibiBytes((long)4L), (long)nodeCount);
        int[] counts = new int[nodeCount];
        for (int nodeId = 0; nodeId < counts.length; ++nodeId) {
            counts[nodeId] = this.random.nextInt(10);
            this.setCount(cache, nodeId, counts[nodeId]);
        }
        long toNodeId = cache.prepare(0L);
        Assert.assertTrue((toNodeId < (long)nodeCount ? 1 : 0) != 0);
        boolean thereAreMoreGroups = true;
        int cachedCount = 0;
        while (thereAreMoreGroups) {
            thereAreMoreGroups = false;
            for (int nodeId = 0; nodeId < nodeCount; ++nodeId) {
                int typeId;
                if (counts[nodeId] <= 0) continue;
                thereAreMoreGroups = true;
                int n = nodeId;
                counts[n] = counts[n] - 1;
                if (!cache.put(new RelationshipGroupRecord((long)nodeId).initialize(true, typeId, -1L, -1L, -1L, (long)nodeId, -1L))) continue;
                ++cachedCount;
            }
        }
        Assert.assertTrue(((long)cachedCount >= toNodeId ? 1 : 0) != 0);
        int readCount = 0;
        for (RelationshipGroupRecord cachedGroup : cache) {
            Assert.assertTrue((cachedGroup.getOwningNode() >= 0L && cachedGroup.getOwningNode() < toNodeId ? 1 : 0) != 0);
            ++readCount;
        }
        Assert.assertEquals((long)cachedCount, (long)readCount);
    }

    @Test
    public void shouldNotFindSpaceToPutMoreGroupsThanSpecifiedForANode() throws Exception {
        int nodeCount = 10;
        RelationshipGroupCache cache = new RelationshipGroupCache(NumberArrayFactory.HEAP, ByteUnit.kibiBytes((long)4L), (long)nodeCount);
        this.setCount(cache, 1, 7);
        Assert.assertEquals((long)nodeCount, (long)cache.prepare(0L));
        for (int i = 0; i < 7; ++i) {
            cache.put(new RelationshipGroupRecord((long)(i + 1)).initialize(true, i, -1L, -1L, -1L, 1L, -1L));
        }
        try {
            cache.put(new RelationshipGroupRecord(8L).initialize(true, 8, -1L, -1L, -1L, 1L, -1L));
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldSortOutOfOrderTypes() throws Exception {
        int nodeCount = 100;
        RelationshipGroupCache cache = new RelationshipGroupCache(NumberArrayFactory.HEAP, ByteUnit.kibiBytes((long)40L), (long)nodeCount);
        int[] counts = new int[nodeCount];
        int groupCount = 0;
        for (int nodeId = 0; nodeId < counts.length; ++nodeId) {
            counts[nodeId] = this.random.nextInt(10);
            this.setCount(cache, nodeId, counts[nodeId]);
            groupCount += counts[nodeId];
        }
        Assert.assertEquals((long)nodeCount, (long)cache.prepare(0L));
        boolean thereAreMoreGroups = true;
        int cachedCount = 0;
        int[] types = this.scrambledTypes(10);
        int i = 0;
        while (thereAreMoreGroups) {
            int typeId = types[i];
            thereAreMoreGroups = false;
            for (int nodeId = 0; nodeId < nodeCount; ++nodeId) {
                if (counts[nodeId] <= 0) continue;
                thereAreMoreGroups = true;
                if (!cache.put(new RelationshipGroupRecord((long)nodeId).initialize(true, typeId, -1L, -1L, -1L, (long)nodeId, -1L))) continue;
                ++cachedCount;
                int n = nodeId;
                counts[n] = counts[n] - 1;
            }
            ++i;
        }
        Assert.assertEquals((long)groupCount, (long)cachedCount);
        long currentNodeId = -1L;
        int currentTypeId = -1;
        int readCount = 0;
        for (RelationshipGroupRecord group : cache) {
            Assert.assertTrue((group.getOwningNode() >= currentNodeId ? 1 : 0) != 0);
            if (group.getOwningNode() > currentNodeId) {
                currentNodeId = group.getOwningNode();
                currentTypeId = -1;
            }
            Assert.assertTrue((group.getType() > currentTypeId ? 1 : 0) != 0);
            ++readCount;
        }
        Assert.assertEquals((long)cachedCount, (long)readCount);
    }

    private int[] scrambledTypes(int count) {
        int i;
        int[] types = new int[count];
        for (i = 0; i < count; ++i) {
            types[i] = i;
        }
        for (i = 0; i < 10; ++i) {
            this.swap(types, i, this.random.nextInt(count));
        }
        return types;
    }

    private void swap(int[] types, int a, int b) {
        int temp = types[a];
        types[a] = types[b];
        types[b] = temp;
    }

    private void setCount(RelationshipGroupCache cache, int nodeId, int count) {
        for (int i = 0; i < count; ++i) {
            cache.incrementGroupCount((long)nodeId);
        }
    }
}

