/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.test.SystemExitError;
import org.neo4j.test.TestSecurityManager;

public class SystemExitRule
extends ExternalResource {
    private Integer expectedExitStatusCode;
    private SecurityManager originalSecurityManager = null;

    public static SystemExitRule none() {
        return new SystemExitRule();
    }

    private SystemExitRule() {
    }

    public void expectExit(int statusCode) {
        this.expectedExitStatusCode = statusCode;
    }

    protected void before() throws Throwable {
        this.originalSecurityManager = System.getSecurityManager();
        TestSecurityManager testSecurityManager = new TestSecurityManager(this.originalSecurityManager);
        System.setSecurityManager(testSecurityManager);
    }

    public Statement apply(Statement base, Description description) {
        final Statement externalRuleStatement = super.apply(base, description);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    externalRuleStatement.evaluate();
                    if (SystemExitRule.this.exitWasExpected()) {
                        Assert.fail((String)"System exit call was expected, but not invoked.");
                    }
                }
                catch (SystemExitError e) {
                    int exceptionStatusCode = e.getStatusCode();
                    if (SystemExitRule.this.exitWasExpected()) {
                        int expectedCode = SystemExitRule.this.expectedExitStatusCode;
                        Assert.assertEquals((String)String.format("Expected system exit code:%d but was: %d.", expectedCode, exceptionStatusCode), (long)expectedCode, (long)exceptionStatusCode);
                    }
                    Assert.fail((String)("System exit call was not expected, but was invoked. Exit status code: " + exceptionStatusCode));
                }
            }
        };
    }

    protected void after() {
        System.setSecurityManager(this.originalSecurityManager);
    }

    private boolean exitWasExpected() {
        return this.expectedExitStatusCode != null;
    }
}

