/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class SuppressOutput
implements TestRule {
    private static final Suppressible java_util_logging = SuppressOutput.java_util_logging(new ByteArrayOutputStream(), null);
    private final Suppressible[] suppressibles;
    private Voice[] voices;

    public static SuppressOutput suppress(Suppressible ... suppressibles) {
        return new SuppressOutput(suppressibles);
    }

    public static SuppressOutput suppressAll() {
        return SuppressOutput.suppress(System.out, System.err, java_util_logging);
    }

    public static Suppressible java_util_logging(final ByteArrayOutputStream redirectTo, Level level) {
        StreamHandler replacement;
        StreamHandler streamHandler = replacement = redirectTo == null ? null : new StreamHandler(redirectTo, new SimpleFormatter());
        if (replacement != null && level != null) {
            replacement.setLevel(level);
        }
        return new Suppressible(){

            @Override
            public Voice suppress() {
                Handler[] handlers;
                final Logger logger = LogManager.getLogManager().getLogger("");
                final Level level = logger.getLevel();
                for (Handler handler : handlers = logger.getHandlers()) {
                    logger.removeHandler(handler);
                }
                if (replacement != null) {
                    logger.addHandler(replacement);
                    logger.setLevel(Level.ALL);
                }
                return new Voice(this, redirectTo){

                    @Override
                    void restore(boolean failure) throws IOException {
                        for (Handler handler : handlers) {
                            logger.addHandler(handler);
                        }
                        logger.setLevel(level);
                        if (replacement != null) {
                            logger.removeHandler(replacement);
                        }
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Callable<T> callable) throws Exception {
        this.voices = this.captureVoices();
        boolean failure = true;
        try {
            T result = callable.call();
            failure = false;
            T t = result;
            return t;
        }
        finally {
            this.releaseVoices(this.voices, failure);
        }
    }

    private SuppressOutput(Suppressible[] suppressibles) {
        this.suppressibles = suppressibles;
    }

    public Voice[] getAllVoices() {
        return this.voices;
    }

    public Voice getOutputVoice() {
        return this.getVoice(System.out);
    }

    public Voice getErrorVoice() {
        return this.getVoice(System.err);
    }

    public Voice getVoice(Suppressible suppressible) {
        for (Voice voice : this.voices) {
            if (!suppressible.equals(voice.getSuppressible())) continue;
            return voice;
        }
        return null;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                SuppressOutput.access$102(SuppressOutput.this, SuppressOutput.this.captureVoices());
                boolean failure = true;
                try {
                    base.evaluate();
                    failure = false;
                }
                finally {
                    SuppressOutput.this.releaseVoices(SuppressOutput.this.voices, failure);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Voice[] captureVoices() {
        Voice[] voices = new Voice[this.suppressibles.length];
        boolean ok = false;
        try {
            for (int i = 0; i < voices.length; ++i) {
                voices[i] = this.suppressibles[i].suppress();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.releaseVoices(voices, false);
            }
        }
        return voices;
    }

    void releaseVoices(Voice[] voices, boolean failure) {
        ArrayList<Throwable> failures = null;
        try {
            failures = new ArrayList<Throwable>(voices.length);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Voice voice : voices) {
            if (voice == null) continue;
            try {
                voice.restore(failure);
            }
            catch (Throwable exception) {
                if (failures == null) continue;
                failures.add(exception);
            }
        }
        if (failures != null && !failures.isEmpty()) {
            for (Throwable exception : failures) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Voice[] access$102(SuppressOutput x0, Voice[] x1) {
        x0.voices = x1;
        return x1;
    }

    public static abstract class Voice {
        private Suppressible suppressible;
        private ByteArrayOutputStream voiceStream;

        public Voice(Suppressible suppressible, ByteArrayOutputStream originalStream) {
            this.suppressible = suppressible;
            this.voiceStream = originalStream;
        }

        public Suppressible getSuppressible() {
            return this.suppressible;
        }

        public boolean containsMessage(String message) {
            return this.voiceStream.toString().contains(message);
        }

        public List<String> lines() {
            return Arrays.asList(this.toString().split(java.lang.System.lineSeparator()));
        }

        public String toString() {
            try {
                return this.voiceStream.toString(StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        abstract void restore(boolean var1) throws IOException;
    }

    public static interface Suppressible {
        public Voice suppress();
    }

    public static enum System implements Suppressible
    {
        out{

            @Override
            PrintStream replace(PrintStream replacement) {
                PrintStream old = java.lang.System.out;
                java.lang.System.setOut(replacement);
                return old;
            }
        }
        ,
        err{

            @Override
            PrintStream replace(PrintStream replacement) {
                PrintStream old = java.lang.System.err;
                java.lang.System.setErr(replacement);
                return old;
            }
        };


        @Override
        public Voice suppress() {
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            final PrintStream old = this.replace(new PrintStream(buffer));
            return new Voice(this, buffer){

                @Override
                void restore(boolean failure) throws IOException {
                    this.replace(old).flush();
                    if (failure) {
                        old.write(buffer.toByteArray());
                    }
                }
            };
        }

        abstract PrintStream replace(PrintStream var1);
    }
}

