/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Race {
    private final List<Contestant> contestants = new ArrayList<Contestant>();
    private volatile CountDownLatch readySet;
    private final CountDownLatch go = new CountDownLatch(1);
    private final boolean addSomeMinorRandomStartDelays;

    public Race() {
        this(false);
    }

    public Race(boolean addSomeMinorRandomStartDelays) {
        this.addSomeMinorRandomStartDelays = addSomeMinorRandomStartDelays;
    }

    public void addContestant(Runnable contestant) {
        this.contestants.add(new Contestant(contestant, this.contestants.size()));
    }

    public void go() throws Throwable {
        this.go(0L, TimeUnit.MILLISECONDS);
    }

    public void go(long maxWaitTime, TimeUnit unit) throws Throwable {
        this.readySet = new CountDownLatch(this.contestants.size());
        for (Contestant contestant : this.contestants) {
            contestant.start();
        }
        this.readySet.await();
        this.go.countDown();
        int errorCount = 0;
        long maxWaitTimeMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long waitedSoFar = 0L;
        for (Contestant contestant : this.contestants) {
            if (maxWaitTime == 0L) {
                contestant.join();
            } else {
                if (waitedSoFar >= maxWaitTimeMillis) {
                    throw new TimeoutException("Didn't complete after " + maxWaitTime + " " + (Object)((Object)unit));
                }
                long time = System.currentTimeMillis();
                contestant.join(maxWaitTimeMillis - waitedSoFar);
                waitedSoFar += System.currentTimeMillis() - time;
            }
            if (contestant.error == null) continue;
            ++errorCount;
        }
        if (errorCount > 1) {
            Throwable errors = new Throwable("Multiple errors found");
            for (Contestant contestant : this.contestants) {
                if (contestant.error == null) continue;
                errors.addSuppressed(contestant.error);
            }
            throw errors;
        }
        if (errorCount == 1) {
            for (Contestant contestant : this.contestants) {
                if (contestant.error == null) continue;
                throw contestant.error;
            }
        }
    }

    private class Contestant
    extends Thread {
        private volatile Throwable error;

        Contestant(Runnable code, int nr) {
            super(code, "Contestant#" + nr);
        }

        @Override
        public void run() {
            Race.this.readySet.countDown();
            try {
                Race.this.go.await();
            }
            catch (InterruptedException e) {
                this.error = e;
                this.interrupt();
                return;
            }
            if (Race.this.addSomeMinorRandomStartDelays) {
                this.randomlyDelaySlightly();
            }
            try {
                super.run();
            }
            catch (Throwable e) {
                this.error = e;
                throw e;
            }
        }

        private void randomlyDelaySlightly() {
            int target = ThreadLocalRandom.current().nextInt(1000000000);
            for (int i = 0; i < target; ++i) {
            }
        }
    }
}

