/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;

public class GraphDatabaseServiceCleaner {
    private GraphDatabaseServiceCleaner() {
        throw new UnsupportedOperationException();
    }

    public static void cleanDatabaseContent(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            for (ConstraintDefinition constraint : db.schema().getConstraints()) {
                constraint.drop();
            }
            for (IndexDefinition index : db.schema().getIndexes()) {
                index.drop();
            }
            tx.success();
        }
        tx = db.beginTx();
        var2_2 = null;
        try {
            for (Relationship relationship : db.getAllRelationships()) {
                relationship.delete();
            }
            for (Node node : db.getAllNodes()) {
                node.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

