/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;

public class EphemeralFileSystemRule
extends ExternalResource
implements Supplier<FileSystemAbstraction> {
    private EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();

    protected void after() {
        this.fs.shutdown();
    }

    @Override
    public final EphemeralFileSystemAbstraction get() {
        return this.fs;
    }

    public EphemeralFileSystemAbstraction snapshot(Runnable action) {
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot();
        try {
            action.run();
        }
        finally {
            this.fs.shutdown();
            this.fs = snapshot;
        }
        return this.fs;
    }

    public void clear() {
        this.fs.shutdown();
        this.fs = new EphemeralFileSystemAbstraction();
    }

    public static Runnable shutdownDbAction(GraphDatabaseService db) {
        return () -> db.shutdown();
    }
}

