/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class DoubleLatch {
    private static final int FIVE_MINUTES = 5;
    private final CountDownLatch startSignal;
    private final CountDownLatch finishSignal;
    private final int numberOfContestants;

    public DoubleLatch() {
        this(1);
    }

    public DoubleLatch(int numberOfContestants) {
        this.numberOfContestants = numberOfContestants;
        this.startSignal = new CountDownLatch(numberOfContestants);
        this.finishSignal = new CountDownLatch(numberOfContestants);
    }

    public int getNumberOfContestants() {
        return this.numberOfContestants;
    }

    public void startAndAwaitFinish() {
        this.start();
        DoubleLatch.awaitLatch(this.finishSignal);
    }

    public void awaitStart() {
        DoubleLatch.awaitLatch(this.startSignal);
    }

    public void start() {
        this.startSignal.countDown();
        DoubleLatch.awaitLatch(this.startSignal);
    }

    public void finish() {
        this.finishSignal.countDown();
    }

    public void awaitFinish() {
        DoubleLatch.awaitLatch(this.finishSignal);
    }

    public static void awaitLatch(CountDownLatch latch) {
        try {
            Assert.assertTrue((String)"Latch specified waiting time elapsed.", (boolean)latch.await(5L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException("Thread interrupted while waiting on latch", e);
        }
    }

    public String toString() {
        return super.toString() + "[Start[" + this.startSignal.getCount() + "], Finish[" + this.finishSignal.getCount() + "]]";
    }
}

