/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.Map;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPageCache;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.tracing.Tracers;

public class AdversarialPageCacheGraphDatabaseFactory {
    private AdversarialPageCacheGraphDatabaseFactory() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static GraphDatabaseFactory create(final FileSystemAbstraction fs, final Adversary adversary) {
        return new GraphDatabaseFactory(){

            protected GraphDatabaseService newDatabase(File dir, Map<String, String> config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return new CommunityFacadeFactory(){

                    protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade facade) {
                        return new PlatformModule(storeDir, params, this.databaseInfo(), dependencies, facade){

                            protected FileSystemAbstraction createFileSystemAbstraction() {
                                return fs;
                            }

                            protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers) {
                                PageCache pageCache = super.createPageCache(fileSystem, config, logging, tracers);
                                return new AdversarialPageCache(pageCache, adversary);
                            }
                        };
                    }
                }.newFacade(dir, config, dependencies);
            }
        };
    }
}

