/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.qa.tooling;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class DumpVmInformation {
    public static void dumpVmInfo(File directory) throws IOException {
        File file = new File(directory, "main-vm-dump-" + System.currentTimeMillis());
        try (PrintStream out = null;){
            out = new PrintStream(file);
            DumpVmInformation.dumpVmInfo(out);
        }
    }

    public static void dumpVmInfo(PrintStream out) {
        ThreadGroup topThreadGroup = Thread.currentThread().getThreadGroup();
        while (topThreadGroup.getParent() != null) {
            topThreadGroup = topThreadGroup.getParent();
        }
        ThreadGroup[] allGroups = new ThreadGroup[1000];
        topThreadGroup.enumerate(allGroups, true);
        for (ThreadGroup group : allGroups) {
            if (group == null) break;
            DumpVmInformation.dumpThreadGroupInfo(group, out);
        }
        DumpVmInformation.dumpThreadGroupInfo(topThreadGroup, out);
    }

    public static void dumpThreadGroupInfo(ThreadGroup tg, PrintStream out) {
        String parentName = tg.getParent() == null ? null : tg.getParent().getName();
        out.println("---- GROUP:" + tg.getName() + (parentName != null ? " parent:" + parentName : "") + (tg.isDaemon() ? " daemon" : "") + (tg.isDestroyed() ? " destroyed" : "") + " ----");
        Thread[] allThreads = new Thread[1000];
        tg.enumerate(allThreads, false);
        for (Thread thread : allThreads) {
            if (thread == null) break;
            out.println("\"" + thread.getName() + "\"" + (thread.isDaemon() ? " daemon" : "") + " prio=" + thread.getPriority() + " tid=" + thread.getId() + " " + thread.getState().name().toLowerCase());
            out.println("  " + Thread.State.class.getName() + ": " + thread.getState().name());
            for (StackTraceElement element : thread.getStackTrace()) {
                out.println("\tat " + element);
            }
        }
    }
}

