/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;

public class LatestCheckPointFinderTest {
    private final PhysicalLogFiles logFiles = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogEntryReader<ReadableClosablePositionAwareChannel> reader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
    private final int olderLogVersion = 0;
    private final int logVersion = 1;

    @Before
    public void setup() throws IOException {
        int i = 0;
        while (i <= 1) {
            File file = (File)Mockito.mock(File.class);
            Mockito.when((Object)this.logFiles.getLogFileForVersion((long)i)).thenReturn((Object)file);
            StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
            Mockito.when((Object)this.fs.open((File)Matchers.eq((Object)file), Matchers.anyString())).thenReturn((Object)channel);
            int version = i++;
            Mockito.when((Object)channel.read((ByteBuffer)Matchers.any(ByteBuffer.class))).thenAnswer(invocationOnMock -> {
                ByteBuffer buffer = (ByteBuffer)invocationOnMock.getArguments()[0];
                buffer.putLong(LogHeaderWriter.encodeLogVersion((long)version));
                buffer.putLong(33L);
                return 16;
            });
        }
        Mockito.when((Object)this.fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)true);
    }

    @Test
    public void noLogFilesFound() throws Throwable {
        Mockito.when((Object)this.logFiles.getLogFileForVersion(1L)).thenReturn(Mockito.mock(File.class));
        Mockito.when((Object)this.fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)false);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, false, -1L), (Object)latestCheckPoint);
    }

    @Test
    public void oneLogFileNoCheckPoints() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(0L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, false, 0L), (Object)latestCheckPoint);
    }

    @Test
    public void oneLogFileNoCheckPointsOneStart() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(0L, 16L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, null);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(0L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, true, 0L), (Object)latestCheckPoint);
    }

    @Test
    public void twoLogFilesNoCheckPoints() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, false, 0L), (Object)latestCheckPoint);
    }

    @Test
    public void twoLogFilesNoCheckPointsOneStart() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(1L, 16L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, null);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, true, 0L), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointOnly() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        CheckPoint checkPoint = new CheckPoint(new LogPosition(1L, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)checkPoint, null);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, 1L), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartBefore() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(1L, 16L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition(1L, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, (Object[])new LogEntry[]{checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, 1L), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartAfter() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        CheckPoint checkPoint = new CheckPoint(new LogPosition(1L, 16L));
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(1L, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, (Object[])new LogEntry[]{checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, 1L), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartAtSamePosition() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        CheckPoint checkPoint = new CheckPoint(new LogPosition(1L, 16L));
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(1L, 16L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, (Object[])new LogEntry[]{checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, 1L), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartInBetween() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(1L, 22L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition(1L, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn(Mockito.mock(CheckPoint.class), (Object[])new LogEntry[]{start, checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, 1L), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartAfterBoth() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        CheckPoint checkPoint = new CheckPoint(new LogPosition(1L, 22L));
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(1L, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn(Mockito.mock(CheckPoint.class), (Object[])new LogEntry[]{checkPoint, start, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, 1L), (Object)latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileContainingAStart() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start1 = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(1L, 22L));
        LogEntryStart start2 = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(0L, 16L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition(0L, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start1, (Object[])new LogEntry[]{null, start2, checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, 0L), (Object)latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileIsEmpty() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(0L, 16L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition(0L, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn(null, (Object[])new LogEntry[]{start, checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, 0L), (Object)latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStart() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(0L, 22L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition(0L, 16L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)checkPoint, (Object[])new LogEntry[]{start, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, 1L), (Object)latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToALaterPositionThanStart() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(0L, 22L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition(0L, 25L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)checkPoint, (Object[])new LogEntry[]{start, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, 1L), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogEmptyStartEntryBeforeAndAfterCheckPointInTheLastButOneLog() throws Throwable {
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart firstStart = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(0L, 20L));
        LogEntryStart secondStart = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition(0L, 27L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition(0L, 25L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)Matchers.any(ReadableLogChannel.class))).thenReturn(null, (Object[])new LogEntry[]{firstStart, checkPoint, secondStart, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(1L);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, 0L), (Object)latestCheckPoint);
    }
}

