/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.DefaultTransactionTracer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DefaultCheckPointerTracer;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;

public class TracersTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final Monitors monitors = new Monitors();
    private Log log;

    @Before
    public void setUp() {
        this.log = this.logProvider.getLog(this.getClass());
        System.setProperty("org.neo4j.helpers.Service.printServiceLoaderStackTraces", "true");
    }

    @Test
    public void mustProduceNullImplementationsWhenRequested() throws Exception {
        Tracers tracers = new Tracers("null", this.log, this.monitors, this.jobScheduler);
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.is((Object)PageCacheTracer.NULL));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.is((Object)TransactionTracer.NULL));
        this.assertNoWarning();
    }

    @Test
    public void mustProduceNullImplementationsWhenRequestedIgnoringCase() throws Exception {
        Tracers tracers = new Tracers("NuLl", this.log, this.monitors, this.jobScheduler);
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.is((Object)PageCacheTracer.NULL));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.is((Object)TransactionTracer.NULL));
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationForNullConfiguration() throws Exception {
        Tracers tracers = new Tracers(null, this.log, this.monitors, this.jobScheduler);
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequested() throws Exception {
        Tracers tracers = new Tracers("default", this.log, this.monitors, this.jobScheduler);
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequestedIgnoringCase() throws Exception {
        Tracers tracers = new Tracers("DeFaUlT", this.log, this.monitors, this.jobScheduler);
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequestingUnknownImplementation() throws Exception {
        Tracers tracers = new Tracers("there's nothing like this", this.log, this.monitors, this.jobScheduler);
        this.assertDefaultImplementation(tracers);
        this.assertWarning("there's nothing like this");
    }

    private void assertDefaultImplementation(Tracers tracers) {
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.instanceOf(DefaultPageCacheTracer.class));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.instanceOf(DefaultTransactionTracer.class));
        Assert.assertThat((Object)tracers.checkPointTracer, (Matcher)Matchers.instanceOf(DefaultCheckPointerTracer.class));
    }

    private void assertNoWarning() {
        this.logProvider.assertNoLoggingOccurred();
    }

    private void assertWarning(String implementationName) {
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).warn("Using default tracer implementations instead of '%s'", new Object[]{implementationName})});
    }
}

