/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.internal.StoreLocker;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class StoreLockerTest {
    @Rule
    public TargetDirectory.TestDirectory target = TargetDirectory.testDirForTest(StoreLockerTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldObtainLockWhenStoreFileNotLocked() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction((FileSystemAbstraction)new DefaultFileSystemAbstraction()){

            public boolean fileExists(File fileName) {
                return true;
            }
        };
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        try {
            storeLocker.checkLock(this.target.directory("unused"));
        }
        catch (StoreLockException e) {
            Assert.fail();
        }
        finally {
            storeLocker.release();
        }
    }

    @Test
    public void shouldCreateStoreDirAndObtainLockWhenStoreDirDoesNotExist() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction((FileSystemAbstraction)new DefaultFileSystemAbstraction()){

            public boolean fileExists(File fileName) {
                return false;
            }
        };
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        try {
            storeLocker.checkLock(this.target.directory("unused"));
        }
        finally {
            storeLocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotObtainLockWhenStoreDirCannotBeCreated() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction((FileSystemAbstraction)new DefaultFileSystemAbstraction()){

            public void mkdirs(File fileName) throws IOException {
                throw new IOException("store dir could not be created");
            }

            public boolean fileExists(File fileName) {
                return false;
            }
        };
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        File storeDir = this.target.directory("unused");
        try {
            storeLocker.checkLock(storeDir);
            Assert.fail();
        }
        catch (StoreLockException e) {
            String msg = String.format("Unable to create path for store dir: %s. Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", storeDir);
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)msg));
        }
        finally {
            storeLocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotObtainLockWhenUnableToOpenLockFile() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction((FileSystemAbstraction)new DefaultFileSystemAbstraction()){

            public StoreChannel open(File fileName, String mode) throws IOException {
                throw new IOException("cannot open lock file");
            }

            public boolean fileExists(File fileName) {
                return false;
            }
        };
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        File storeDir = this.target.directory("unused");
        try {
            storeLocker.checkLock(storeDir);
            Assert.fail();
        }
        catch (StoreLockException e) {
            String msg = String.format("Unable to obtain lock on store lock file: %s. Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", new File(storeDir, "store_lock"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)msg));
        }
        finally {
            storeLocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotObtainLockWhenStoreAlreadyInUse() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction((FileSystemAbstraction)new DefaultFileSystemAbstraction()){

            public boolean fileExists(File fileName) {
                return false;
            }

            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    public FileLock tryLock() throws IOException {
                        return null;
                    }
                };
            }
        };
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);
        try {
            storeLocker.checkLock(this.target.directory("unused"));
            Assert.fail();
        }
        catch (StoreLockException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Store and its lock file has been locked by another process"));
        }
        finally {
            storeLocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustPreventMultipleInstancesFromStartingOnSameStore() {
        File storeDir = this.target.graphDbDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        try {
            new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
            Assert.fail((String)"Should not be able to start up another db in the same dir");
        }
        catch (Exception exception) {
        }
        finally {
            db.shutdown();
        }
    }
}

