/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class StoreLockerLifecycleAdapterTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldAllowDatabasesToUseFilesetsSequentially() throws Exception {
        this.newDb().shutdown();
        this.newDb().shutdown();
    }

    @Test
    public void shouldNotAllowDatabasesToUseFilesetsConcurrently() throws Exception {
        this.shouldNotAllowDatabasesToUseFilesetsConcurrently(MapUtil.stringMap((String[])new String[0]));
    }

    @Test
    public void shouldNotAllowDatabasesToUseFilesetsConcurrentlyEvenIfTheyAreInReadOnlyMode() throws Exception {
        this.shouldNotAllowDatabasesToUseFilesetsConcurrently(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldNotAllowDatabasesToUseFilesetsConcurrently(Map<String, String> config) throws Exception {
        GraphDatabaseService db = this.newDb();
        try {
            new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir()).setConfig(config).newGraphDatabase();
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)IsInstanceOf.instanceOf(StoreLockException.class));
        }
        finally {
            db.shutdown();
        }
    }

    private GraphDatabaseService newDb() {
        return new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDir());
    }

    private File storeDir() {
        return this.directory.absolutePath();
    }
}

