/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Factory;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.impl.util.collection.ConcurrentAccessException;
import org.neo4j.kernel.impl.util.collection.NoSuchEntryException;
import org.neo4j.kernel.impl.util.collection.TimedRepository;

public class TimedRepositoryTest {
    private final AtomicLong valueGenerator = new AtomicLong();
    private final List<Long> reapedValues = new ArrayList<Long>();
    private final Factory<Long> provider = this.valueGenerator::getAndIncrement;
    private final Consumer<Long> consumer = this.reapedValues::add;
    private final long timeout = 100L;
    private final FakeClock clock = new FakeClock();
    private final TimedRepository<Long, Long> repo = new TimedRepository(this.provider, this.consumer, 100L, (Clock)this.clock);

    @Test
    public void shouldManageLifecycleWithNoTimeouts() throws Exception {
        this.repo.begin((Object)1L);
        long acquired = (Long)this.repo.acquire((Object)1L);
        this.repo.release((Object)1L);
        this.repo.end((Object)1L);
        MatcherAssert.assertThat((Object)acquired, (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(0L)));
    }

    @Test
    public void shouldNotAllowOthersAccessWhenAcquired() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.acquire((Object)1L);
        try {
            this.repo.acquire((Object)1L);
            Assert.fail((String)"Should not have been allowed access.");
        }
        catch (ConcurrentAccessException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Cannot access '1', because another client is currently using it."));
        }
        this.repo.release((Object)1L);
        MatcherAssert.assertThat((Object)this.repo.acquire((Object)1L), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldNotAllowAccessAfterEnd() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.end((Object)1L);
        try {
            this.repo.acquire((Object)1L);
            Assert.fail((String)"Should not have been able to acquire.");
        }
        catch (NoSuchEntryException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Cannot access '1', no such entry exists."));
        }
    }

    @Test
    public void shouldSilentlyAllowMultipleEndings() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.end((Object)1L);
        this.repo.end((Object)1L);
    }

    @Test
    public void shouldNotEndImmediatelyIfEntryIsUsed() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.acquire((Object)1L);
        this.repo.end((Object)1L);
        Assert.assertTrue((boolean)this.reapedValues.isEmpty());
        this.repo.release((Object)1L);
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(0L)));
    }

    @Test
    public void shouldNotAllowBeginningWithDuplicateKey() throws Exception {
        this.repo.begin((Object)1L);
        try {
            this.repo.begin((Object)1L);
            Assert.fail((String)"Should not have been able to begin.");
        }
        catch (ConcurrentAccessException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot begin '1', because Entry"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)" with that key already exists."));
        }
    }

    @Test
    public void shouldTimeOutUnusedEntries() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.acquire((Object)1L);
        this.repo.release((Object)1L);
        this.repo.run();
        MatcherAssert.assertThat((Object)this.repo.acquire((Object)1L), (Matcher)CoreMatchers.equalTo((Object)0L));
        this.repo.release((Object)1L);
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.repo.run();
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(0L)));
        try {
            this.repo.acquire((Object)1L);
            Assert.fail((String)"Should not have been possible to acquire.");
        }
        catch (NoSuchEntryException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Cannot access '1', no such entry exists."));
        }
    }

    @Test
    public void usingDuplicateKeysShouldDisposeOfPreemptiveAllocatedValue() throws Exception {
        this.repo.begin((Object)1L);
        try {
            this.repo.begin((Object)1L);
            Assert.fail((String)"Should not have been able to begin.");
        }
        catch (ConcurrentAccessException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot begin '1', because Entry"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)" with that key already exists."));
        }
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(1L)));
    }

    @Test
    public void shouldAllowBeginWithSameKeyAfterSessionRelease() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.acquire((Object)1L);
        this.repo.release((Object)1L);
        this.repo.end((Object)1L);
        this.repo.begin((Object)1L);
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(0L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unusedEntriesSafelyAcquiredOnCleanup() throws ConcurrentAccessException, NoSuchEntryException, InterruptedException, TimeoutException, BrokenBarrierException {
        CountDownReaper countDownReaper = new CountDownReaper();
        TimedRepository timedRepository = new TimedRepository(this.provider, (Consumer)countDownReaper, 1L, (Clock)this.clock);
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
        NonStoppableCleaner cleaner = new NonStoppableCleaner((TimedRepository<Object, Long>)timedRepository);
        try {
            singleThreadExecutor.submit(cleaner);
            long entryKey = 1L;
            long iterations = 100000L;
            while (entryKey++ < iterations) {
                timedRepository.begin((Object)entryKey);
                timedRepository.acquire((Object)entryKey);
                this.clock.forward(10L, TimeUnit.MILLISECONDS);
                timedRepository.release((Object)entryKey);
                timedRepository.end((Object)entryKey);
                countDownReaper.await("Reaper should consume entry from cleaner thread or from our 'end' call. If it was not consumed it mean cleaner and worker thread where not able to figure out who removes entry, and block will ends up in the repo forever.", 10L, TimeUnit.SECONDS);
                countDownReaper.reset();
            }
        }
        finally {
            cleaner.stop();
            singleThreadExecutor.shutdownNow();
        }
    }

    private static class CountDownReaper
    implements Consumer<Long> {
        private volatile CountDownLatch reaperLatch;

        CountDownReaper() {
            this.reset();
        }

        public void reset() {
            this.reaperLatch = new CountDownLatch(1);
        }

        @Override
        public void accept(Long aLong) {
            this.reaperLatch.countDown();
        }

        public void await(String message, long timeout, TimeUnit timeUnit) throws InterruptedException {
            if (!this.reaperLatch.await(timeout, timeUnit)) {
                throw new IllegalStateException(message);
            }
        }
    }

    private static class NonStoppableCleaner
    implements Runnable {
        private volatile boolean stop = false;
        private final TimedRepository<Object, Long> timedRepository;

        NonStoppableCleaner(TimedRepository<Object, Long> timedRepository) {
            this.timedRepository = timedRepository;
        }

        @Override
        public void run() {
            while (!this.stop) {
                this.timedRepository.run();
            }
        }

        public void stop() {
            this.stop = true;
        }
    }
}

