/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;

public class PrimitiveIteratorMatchers {
    public static Matcher<PrimitiveLongIterator> containsLongs(final long ... longs) {
        return new TypeSafeMatcher<PrimitiveLongIterator>(){

            protected boolean matchesSafely(PrimitiveLongIterator item) {
                List actual = PrimitiveLongCollections.asList((PrimitiveLongIterator)item);
                List<Long> expected = this.expected();
                block0: for (Long actualValue : actual) {
                    Iterator<Long> expectedIt = expected.iterator();
                    while (expectedIt.hasNext()) {
                        if (!expectedIt.next().equals(actualValue)) continue;
                        expectedIt.remove();
                        continue block0;
                    }
                    TestCase.fail((String)("Got unexpected value: " + actualValue));
                }
                return expected.size() == 0;
            }

            private List<Long> expected() {
                ArrayList<Long> expected = new ArrayList<Long>();
                for (long v : longs) {
                    expected.add(v);
                }
                return expected;
            }

            public void describeTo(Description description) {
                description.appendValueList("[", ",", "]", this.expected());
            }
        };
    }
}

