/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;

public class CountingJobScheduler
implements JobScheduler {
    private final AtomicInteger counter;
    private final Neo4jJobScheduler delegate;

    public CountingJobScheduler(AtomicInteger counter, Neo4jJobScheduler delegate) {
        this.counter = counter;
        this.delegate = delegate;
    }

    public Executor executor(JobScheduler.Group group) {
        return this.delegate.executor(group);
    }

    public ThreadFactory threadFactory(JobScheduler.Group group) {
        return this.delegate.threadFactory(group);
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, job);
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job, Map<String, String> metadata) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, job, metadata);
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, runnable, initialDelay, timeUnit);
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, runnable, period, timeUnit);
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, runnable, initialDelay, period, timeUnit);
    }

    public void init() {
        this.delegate.init();
    }

    public void start() throws Throwable {
        this.delegate.start();
    }

    public void stop() throws Throwable {
        this.delegate.stop();
    }

    public void shutdown() {
        this.delegate.shutdown();
    }
}

